/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.bitwise;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.bitwise.BitwiseMatcher;

public class BitwiseGeneralMatcher
extends BitwiseMatcher {
    private final ByteArray matcher;
    private final ByteArray mask;
    private final boolean maskAll;

    BitwiseGeneralMatcher(ByteArray matcher) {
        this.matcher = matcher;
        this.mask = ByteArray.allocate(matcher.length());
        for (int i = 0; i < this.mask.length(); ++i) {
            this.mask.set(i, (byte)-1);
        }
        this.maskAll = true;
    }

    BitwiseGeneralMatcher(ByteArray matcher, ByteArray mask) {
        this(matcher, mask, false);
    }

    BitwiseGeneralMatcher(ByteArray matcher, ByteArray mask, boolean expandMask) {
        int i;
        this.matcher = matcher;
        if (matcher.length() != mask.length()) {
            if (matcher.length() < mask.length() || !expandMask) {
                throw new IllegalArgumentException("matcher and mask length not the same: matcher: " + matcher.length() + ", mask: " + mask.length());
            }
            ByteArray mask2 = ByteArray.allocateInitZero(matcher.length());
            i = 1;
            while (mask.length() - i >= 0) {
                mask2.set(mask2.length() - i, mask.get(mask.length() - i));
                --i;
            }
            mask = mask2;
        }
        this.mask = mask;
        boolean maskAll = true;
        for (i = 0; i < matcher.length(); ++i) {
            byte m;
            byte b = matcher.get(i);
            if ((b & (m = mask.get(i))) != b) {
                throw new IllegalArgumentException("the matcher does not correspond to the mask");
            }
            if (m == -1) continue;
            maskAll = false;
        }
        this.maskAll = maskAll;
    }

    @Override
    public ByteArray getMatcher() {
        return this.matcher;
    }

    @Override
    public ByteArray getMask() {
        return this.mask;
    }

    @Override
    public boolean maskAll() {
        return this.maskAll;
    }
}

