/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.bitwise;

import io.vproxy.base.util.Utils;
import io.vproxy.base.util.misc.IntMatcher;
import java.util.Objects;

public class BitwiseIntMatcher
implements IntMatcher {
    private final int matcher;
    private final int mask;

    private BitwiseIntMatcher(int matcher) {
        this.matcher = matcher;
        this.mask = -1;
    }

    private BitwiseIntMatcher(int matcher, int mask) {
        this.matcher = matcher;
        this.mask = mask;
        if ((matcher & mask) != matcher) {
            throw new IllegalArgumentException("the matcher does not correspond to the mask");
        }
    }

    public static BitwiseIntMatcher from(int matcher) {
        return new BitwiseIntMatcher(matcher);
    }

    public static BitwiseIntMatcher from(int matcher, int mask) {
        return new BitwiseIntMatcher(matcher, mask);
    }

    @Override
    public boolean match(int n) {
        return (n & this.mask) == this.matcher;
    }

    public int getMatcher() {
        return this.matcher;
    }

    public int getMask() {
        return this.mask;
    }

    public boolean maskAll() {
        return this.mask == -1;
    }

    public String toString() {
        if (this.maskAll()) {
            return Utils.toHexString(this.matcher);
        }
        return Utils.toHexString(this.matcher) + "/" + Utils.toHexString(this.mask);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitwiseIntMatcher that = (BitwiseIntMatcher)o;
        return this.matcher == that.matcher && this.mask == that.mask;
    }

    public int hashCode() {
        return Objects.hash(this.matcher, this.mask);
    }
}

