/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.bitwise;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.Network;
import io.vproxy.base.util.ToByteArray;
import io.vproxy.base.util.bitwise.BitwiseGeneralMatcher;
import io.vproxy.base.util.bitwise.BitwiseIPv4Matcher;
import io.vproxy.base.util.bitwise.BitwiseIPv6Matcher;
import io.vproxy.base.util.bitwise.BitwiseMacAddressMatcher;
import io.vproxy.base.util.bitwise.BitwiseNetworkMatcher;
import io.vproxy.vfd.IP;
import io.vproxy.vfd.MacAddress;
import java.util.Objects;

public abstract class BitwiseMatcher {
    public static BitwiseMatcher from(ByteArray matcher) {
        if (matcher.length() == 6) {
            return new BitwiseMacAddressMatcher(new MacAddress(matcher));
        }
        if (matcher.length() == 4) {
            return new BitwiseIPv4Matcher(IP.fromIPv4(matcher.toJavaArray()));
        }
        if (matcher.length() == 16) {
            return new BitwiseIPv6Matcher(IP.fromIPv6(matcher.toJavaArray()));
        }
        return new BitwiseGeneralMatcher(matcher);
    }

    public static BitwiseMatcher from(ByteArray matcher, ByteArray mask) {
        return BitwiseMatcher.from(matcher, mask, false);
    }

    public static BitwiseMatcher from(ByteArray matcher, ByteArray mask, boolean expandMask) {
        boolean maskAll = true;
        boolean maskPrefix = true;
        for (int i = 0; i < mask.length(); ++i) {
            byte b = mask.get(i);
            if (maskAll) {
                if (b == -1) continue;
                maskAll = false;
                if (b == -2 || b == -4 || b == -8 || b == -16 || b == -32 || b == -64 || b == -128 || b == 0) continue;
                maskPrefix = false;
                continue;
            }
            if (b == 0) continue;
            maskPrefix = false;
        }
        if (maskAll && matcher.length() == mask.length()) {
            return BitwiseMatcher.from(matcher);
        }
        if (maskPrefix && (matcher.length() == 4 || matcher.length() == 16) && (matcher.length() == 4 && mask.length() == 4 || matcher.length() == 16 && (mask.length() == 4 || mask.length() == 16))) {
            return new BitwiseNetworkMatcher(Network.from(IP.from(matcher.toJavaArray()), mask));
        }
        return new BitwiseGeneralMatcher(matcher, mask, expandMask);
    }

    public boolean match(byte[] bytes) {
        return this.match(ByteArray.from(bytes));
    }

    public boolean match(ToByteArray input) {
        return this.match(input.toByteArray());
    }

    public boolean match(ByteArray input) {
        byte matcherByte;
        int matcherLength = this.getMatcher().length();
        int maskLength = this.getMask().length();
        int inputLength = input.length();
        int i = 1;
        while (matcherLength - i >= 0 && maskLength - i >= 0 && inputLength - i >= 0) {
            matcherByte = this.getMatcher().get(matcherLength - i);
            byte maskByte = this.getMask().get(maskLength - i);
            byte inputByte = input.get(inputLength - i);
            if ((inputByte & maskByte) != matcherByte) {
                return false;
            }
            ++i;
        }
        if (inputLength >= matcherLength) {
            return true;
        }
        while (matcherLength - i >= 0 && maskLength - i >= 0) {
            matcherByte = this.getMatcher().get(matcherLength - i);
            if (matcherByte != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public abstract ByteArray getMatcher();

    public abstract ByteArray getMask();

    public abstract boolean maskAll();

    public String toString() {
        if (this.maskAll()) {
            return "0x" + this.getMatcher().toHexString();
        }
        return "0x" + this.getMatcher().toHexString() + "/0x" + this.getMask().toHexString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitwiseMatcher matcher1 = (BitwiseMatcher)o;
        return this.getMatcher().equals(matcher1.getMatcher()) && this.getMask().equals(matcher1.getMask());
    }

    public int hashCode() {
        return Objects.hash(this.getMatcher(), this.getMask());
    }
}

