/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.bytearray;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.Utils;
import io.vproxy.base.util.bytearray.SimpleByteArray;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class AbstractByteArray
implements ByteArray {
    public static final ByteArray EMPTY = new SimpleByteArray(Utils.getZeroLengthByteArray());

    protected void checkBoundForOffset(int off) {
        if (off < 0) {
            throw new IllegalArgumentException("off=" + off + " < 0");
        }
        if (off >= this.length()) {
            throw new ArrayIndexOutOfBoundsException("off=" + off + ", length=" + this.length());
        }
    }

    protected void checkBoundForOffsetAndLength(int off, int len) {
        if (len > 0) {
            this.checkBoundForOffset(off);
        }
        if (len < 0) {
            throw new IllegalArgumentException("len=" + len + " < 0");
        }
        if (off > this.length() || off + len > this.length()) {
            throw new ArrayIndexOutOfBoundsException("off=" + off + ", len=" + len + ", length=" + this.length());
        }
    }

    protected void checkBoundForByteBufferAndOffsetAndLength(ByteBuffer byteBuffer, int off, int len) {
        this.checkBoundForOffsetAndLength(off, len);
        int bLen = byteBuffer.limit() - byteBuffer.position();
        if (bLen < len) {
            throw new IndexOutOfBoundsException("byteBuffer.length=" + bLen + ", len=" + len);
        }
    }

    @Override
    public void toNewJavaArray(byte[] holder, int off) {
        int len = this.length();
        if (len > holder.length - off) {
            throw new IllegalArgumentException("input byte[] and offset cannot hold bytes in this ByteArray: input=" + holder.length + ", off=" + off + ", this=" + len);
        }
        this.doToNewJavaArray(holder, off, 0, len);
    }

    protected abstract void doToNewJavaArray(byte[] var1, int var2, int var3, int var4);

    public boolean equals(Object obj) {
        if (!(obj instanceof ByteArray)) {
            return false;
        }
        ByteArray o = (ByteArray)obj;
        int len = this.length();
        if (len != o.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.get(i) == o.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int len = this.length();
        int ret = 0;
        for (int i = 0; i < len; ++i) {
            ret = ret << 31 | this.get(i);
        }
        return ret;
    }

    public String toString() {
        return this.toString(StandardCharsets.UTF_8);
    }

    public String toString(Charset charset) {
        return new String(this.toJavaArray(), charset);
    }
}

