/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.bytearray;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.bytearray.AbstractByteArray;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ByteArrayBuilder
extends AbstractByteArray
implements ByteArray {
    private static final int DEFAULT_PAGE_SIZE = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private final List<byte[]> bytePages = new ArrayList<byte[]>();
    private final int pageSize;
    private int pageIdx;
    private int arrayIdx;

    public ByteArrayBuilder() {
        this(16);
    }

    public ByteArrayBuilder(int pageSize) {
        if (pageSize <= 0) {
            throw new RuntimeException("'pageSize' MUST be greater than zero");
        }
        this.pageSize = ByteArrayBuilder.tableSizeFor(pageSize);
        this.pageIdx = -1;
        this.arrayIdx = this.pageSize;
    }

    static int tableSizeFor(int cap) {
        int n = -1 >>> Integer.numberOfLeadingZeros(cap - 1);
        return n < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    public ByteArrayBuilder append(byte b) {
        if (this.arrayIdx >= this.pageSize) {
            ++this.pageIdx;
            this.arrayIdx = 0;
            this.bytePages.add(new byte[this.pageSize]);
        }
        this.bytePages.get((int)this.pageIdx)[this.arrayIdx++] = b;
        return this;
    }

    public ByteArrayBuilder append(int ... b) {
        for (int b1 : b) {
            this.append((byte)b1);
        }
        return this;
    }

    private int calcPageIdx(int idx) {
        return idx / this.pageSize;
    }

    private int calcArrayIdx(int idx) {
        return idx % this.pageSize;
    }

    @Override
    public byte get(int idx) {
        return this.bytePages.get(this.calcPageIdx(idx))[this.calcArrayIdx(idx)];
    }

    @Override
    public ByteArray set(int idx, byte value) {
        this.bytePages.get((int)this.calcPageIdx((int)idx))[this.calcArrayIdx((int)idx)] = value;
        return this;
    }

    @Override
    public int length() {
        return this.pageIdx * this.pageSize + this.arrayIdx;
    }

    @Override
    protected void doToNewJavaArray(byte[] dst, int dstOff, int srcOff, int srcLen) {
        int startPageIdx = this.calcPageIdx(srcOff);
        int startArrayIdx = this.calcArrayIdx(srcOff);
        int endPageIdx = this.calcPageIdx(srcOff + srcLen - 1);
        int endArrayIdx = this.calcArrayIdx(srcOff + srcLen - 1);
        for (int page = startPageIdx; page <= endPageIdx; ++page) {
            byte[] array = this.bytePages.get(page);
            int start = page == startPageIdx ? startArrayIdx : 0;
            int end = page == endPageIdx ? endArrayIdx + 1 : this.pageSize;
            int length = end - start;
            System.arraycopy(array, start, dst, dstOff, length);
            dstOff += length;
        }
    }

    @Override
    public void byteBufferPut(ByteBuffer dst, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            dst.put(this.get(i));
        }
    }

    @Override
    public void byteBufferGet(ByteBuffer src, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            this.set(i, src.get());
        }
    }
}

