/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.bytearray;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.bytearray.AbstractByteArray;
import java.nio.ByteBuffer;

public class CompositeByteArray
extends AbstractByteArray
implements ByteArray {
    private final ByteArray first;
    private final ByteArray second;
    private final int len;

    public CompositeByteArray(ByteArray first, ByteArray second) {
        this.first = first;
        this.second = second;
        this.len = first.length() + second.length();
    }

    @Override
    public byte get(int idx) {
        this.checkBoundForOffset(idx);
        if (idx >= this.len || idx < 0) {
            throw new ArrayIndexOutOfBoundsException("index=" + idx + ", length=" + this.len);
        }
        if (idx < this.first.length()) {
            return this.first.get(idx);
        }
        return this.second.get(idx - this.first.length());
    }

    @Override
    public ByteArray set(int idx, byte value) {
        this.checkBoundForOffset(idx);
        if (idx >= this.len || idx < 0) {
            throw new ArrayIndexOutOfBoundsException("index=" + idx + ", length=" + this.len);
        }
        if (idx < this.first.length()) {
            this.first.set(idx, value);
        } else {
            this.second.set(idx - this.first.length(), value);
        }
        return this;
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public void byteBufferPut(ByteBuffer dst, int off, int len) {
        this.checkBoundForByteBufferAndOffsetAndLength(dst, off, len);
        int firstLen = this.first.length();
        if (off > firstLen) {
            this.second.byteBufferPut(dst, off - firstLen, len);
            return;
        }
        if (len < firstLen - off) {
            this.first.byteBufferPut(dst, off, len);
            return;
        }
        this.first.byteBufferPut(dst, off, firstLen - off);
        this.second.byteBufferPut(dst, 0, len - (firstLen - off));
    }

    @Override
    public void byteBufferGet(ByteBuffer src, int off, int len) {
        this.checkBoundForByteBufferAndOffsetAndLength(src, off, len);
        int firstLen = this.first.length();
        if (off > firstLen) {
            this.second.byteBufferGet(src, off - firstLen, len);
            return;
        }
        if (len < firstLen - off) {
            this.first.byteBufferGet(src, off, len);
            return;
        }
        this.first.byteBufferGet(src, off, firstLen - off);
        this.second.byteBufferGet(src, 0, len - (firstLen - off));
    }

    @Override
    protected void doToNewJavaArray(byte[] dst, int dstOff, int srcOff, int srcLen) {
        int firstLen = this.first.length();
        if (firstLen > srcOff) {
            int off = srcOff;
            int len = Math.min(srcLen, firstLen - off);
            ((AbstractByteArray)this.first).doToNewJavaArray(dst, dstOff, off, len);
            if (srcLen > len) {
                ((AbstractByteArray)this.second).doToNewJavaArray(dst, dstOff + len, 0, srcLen - len);
            }
        } else {
            ((AbstractByteArray)this.second).doToNewJavaArray(dst, dstOff, srcOff - firstLen, srcLen);
        }
    }
}

