/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.bytearray;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.bytearray.AbstractByteArray;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MemorySegmentByteArray
extends AbstractByteArray
implements ByteArray {
    private static final Class<?> MemorySegment;
    private static final Object JAVA_BYTE;
    private static final MethodHandle getByte;
    private static final MethodHandle setByte;
    private static final MethodHandle byteSize;
    private static final MethodHandle asByteBuffer;
    private static final MethodHandle asSlice;
    private static final MethodHandle copyFrom;
    private static final MethodHandle getLong;
    private static final MethodHandle getInt;
    private static final MethodHandle getShort;
    private static final MethodHandle setLong;
    private static final MethodHandle setInt;
    private static final MethodHandle setShort;
    protected final Object seg;
    private static final Object LONG_BIG_ENDIAN;
    private static final Object LONG_LITTLE_ENDIAN;
    private static final Object INT_BIG_ENDIAN;
    private static final Object INT_LITTLE_ENDIAN;
    private static final Object SHORT_BIG_ENDIAN;
    private static final Object SHORT_LITTLE_ENDIAN;

    public MemorySegmentByteArray(Object seg) {
        if (!MemorySegment.isInstance(seg)) {
            throw new IllegalArgumentException(seg.getClass().getName() + " is not MemorySegment");
        }
        this.seg = seg;
    }

    public Object getMemorySegment() {
        return this.seg;
    }

    @Override
    public byte get(int idx) {
        try {
            return getByte.invoke(this.seg, JAVA_BYTE, idx);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public ByteArray set(int idx, byte value) {
        try {
            setByte.invoke(this.seg, JAVA_BYTE, idx, value);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
        return this;
    }

    @Override
    public int length() {
        try {
            return (int)byteSize.invoke(this.seg);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public void byteBufferPut(ByteBuffer dst, int off, int len) {
        try {
            dst.put(asByteBuffer.invoke(this.seg).limit(off + len).position(off));
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public void byteBufferGet(ByteBuffer src, int off, int len) {
        try {
            asByteBuffer.invoke(this.seg).limit(off + len).position(off).put(src);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public void copyInto(ByteArray dst, int dstOff, int srcOff, int srcLen) {
        Object thisSegSlice;
        Object segBufSegSlice;
        if (!(dst instanceof MemorySegmentByteArray)) {
            super.copyInto(dst, dstOff, srcOff, srcLen);
            return;
        }
        MemorySegmentByteArray segBuf = (MemorySegmentByteArray)dst;
        try {
            segBufSegSlice = asSlice.invoke(segBuf.seg, dstOff, srcLen);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
        try {
            thisSegSlice = asSlice.invoke(this.seg, srcOff, srcLen);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
        try {
            copyFrom.invoke(segBufSegSlice, thisSegSlice);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    protected void doToNewJavaArray(byte[] dst, int dstOff, int srcOff, int srcLen) {
        ByteBuffer buf;
        try {
            buf = asByteBuffer.invoke(this.seg);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
        buf.limit(srcOff + srcLen).position(srcOff).get(dst, dstOff, srcLen);
    }

    @Override
    public long int64(int offset) {
        try {
            return getLong.invoke(this.seg, LONG_BIG_ENDIAN, offset);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public long int64ReverseNetworkByteOrder(int offset) {
        try {
            return getLong.invoke(this.seg, LONG_LITTLE_ENDIAN, offset);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public int int32(int offset) {
        try {
            return getInt.invoke(this.seg, INT_BIG_ENDIAN, offset);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public int int32ReverseNetworkByteOrder(int offset) {
        try {
            return getInt.invoke(this.seg, INT_LITTLE_ENDIAN, offset);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public long uint32(int offset) {
        return (long)this.int32(offset) & 0xFFFFFFFFL;
    }

    @Override
    public long uint32ReverseNetworkByteOrder(int offset) {
        return (long)this.int32ReverseNetworkByteOrder(offset) & 0xFFFFFFFFL;
    }

    @Override
    public int uint16(int offset) {
        try {
            return getShort.invoke(this.seg, SHORT_BIG_ENDIAN, offset) & 0xFFFF;
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public int uint16ReverseNetworkByteOrder(int offset) {
        try {
            return getShort.invoke(this.seg, SHORT_LITTLE_ENDIAN, offset) & 0xFFFF;
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public ByteArray int16(int offset, int val) {
        try {
            setShort.invoke(this.seg, SHORT_BIG_ENDIAN, offset, (short)val);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
        return this;
    }

    @Override
    public ByteArray int16ReverseNetworkByteOrder(int offset, int val) {
        try {
            setShort.invoke(this.seg, SHORT_LITTLE_ENDIAN, offset, (short)val);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
        return this;
    }

    @Override
    public ByteArray int32(int offset, int val) {
        try {
            setInt.invoke(this.seg, INT_BIG_ENDIAN, offset, val);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
        return this;
    }

    @Override
    public ByteArray int32ReverseNetworkByteOrder(int offset, int val) {
        try {
            setInt.invoke(this.seg, INT_LITTLE_ENDIAN, offset, val);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
        return this;
    }

    @Override
    public ByteArray int64(int offset, long val) {
        try {
            setLong.invoke(this.seg, LONG_BIG_ENDIAN, offset, val);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
        return this;
    }

    @Override
    public ByteArray int64ReverseNetworkByteOrder(int offset, long val) {
        try {
            setLong.invoke(this.seg, LONG_LITTLE_ENDIAN, offset, val);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
        return this;
    }

    @Override
    public ByteArray sub(int fromInclusive, int len) {
        Object newSeg;
        try {
            newSeg = asSlice.invoke(this.seg, fromInclusive, len);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
        return new MemorySegmentByteArray(newSeg);
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            String CLASSNAME = "java.lang.foreign.MemorySegment";
            MemorySegment = Class.forName(CLASSNAME);
            Class<?> ValueLayout2 = Class.forName("java.lang.foreign.ValueLayout");
            JAVA_BYTE = ValueLayout2.getField("JAVA_BYTE").get(null);
            Class<?> ValueLayout$OfLong = Class.forName("java.lang.foreign.ValueLayout$OfLong");
            Object _LONG_BIG_ENDIAN = ValueLayout2.getField("JAVA_LONG_UNALIGNED").get(null);
            LONG_BIG_ENDIAN = _LONG_BIG_ENDIAN = ValueLayout$OfLong.getMethod("withOrder", ByteOrder.class).invoke(_LONG_BIG_ENDIAN, ByteOrder.BIG_ENDIAN);
            Object _LONG_LITTLE_ENDIAN = ValueLayout2.getField("JAVA_LONG_UNALIGNED").get(null);
            LONG_LITTLE_ENDIAN = _LONG_LITTLE_ENDIAN = ValueLayout$OfLong.getMethod("withOrder", ByteOrder.class).invoke(_LONG_BIG_ENDIAN, ByteOrder.LITTLE_ENDIAN);
            getLong = lookup.findVirtual(MemorySegment, "get", MethodType.methodType(Long.TYPE, ValueLayout$OfLong, Long.TYPE));
            setLong = lookup.findVirtual(MemorySegment, "set", MethodType.methodType(Void.TYPE, ValueLayout$OfLong, Long.TYPE, Long.TYPE));
            Class<?> ValueLayout$OfInt = Class.forName("java.lang.foreign.ValueLayout$OfInt");
            Object _INT_BIG_ENDIAN = ValueLayout2.getField("JAVA_INT_UNALIGNED").get(null);
            INT_BIG_ENDIAN = _INT_BIG_ENDIAN = ValueLayout$OfInt.getMethod("withOrder", ByteOrder.class).invoke(_INT_BIG_ENDIAN, ByteOrder.BIG_ENDIAN);
            Object _INT_LITTLE_ENDIAN = ValueLayout2.getField("JAVA_INT_UNALIGNED").get(null);
            INT_LITTLE_ENDIAN = _INT_LITTLE_ENDIAN = ValueLayout$OfInt.getMethod("withOrder", ByteOrder.class).invoke(_INT_LITTLE_ENDIAN, ByteOrder.LITTLE_ENDIAN);
            getInt = lookup.findVirtual(MemorySegment, "get", MethodType.methodType(Integer.TYPE, ValueLayout$OfInt, Long.TYPE));
            setInt = lookup.findVirtual(MemorySegment, "set", MethodType.methodType(Void.TYPE, ValueLayout$OfInt, Long.TYPE, Integer.TYPE));
            Class<?> ValueLayout$OfShort = Class.forName("java.lang.foreign.ValueLayout$OfShort");
            Object _SHORT_BIG_ENDIAN = ValueLayout2.getField("JAVA_SHORT_UNALIGNED").get(null);
            SHORT_BIG_ENDIAN = _SHORT_BIG_ENDIAN = ValueLayout$OfShort.getMethod("withOrder", ByteOrder.class).invoke(_SHORT_BIG_ENDIAN, ByteOrder.BIG_ENDIAN);
            Object _SHORT_LITTLE_ENDIAN = ValueLayout2.getField("JAVA_SHORT_UNALIGNED").get(null);
            SHORT_LITTLE_ENDIAN = _SHORT_LITTLE_ENDIAN = ValueLayout$OfShort.getMethod("withOrder", ByteOrder.class).invoke(_SHORT_LITTLE_ENDIAN, ByteOrder.LITTLE_ENDIAN);
            getShort = lookup.findVirtual(MemorySegment, "get", MethodType.methodType(Short.TYPE, ValueLayout$OfShort, Long.TYPE));
            setShort = lookup.findVirtual(MemorySegment, "set", MethodType.methodType(Void.TYPE, ValueLayout$OfShort, Long.TYPE, Short.TYPE));
            Class<?> ValueLayout$OfByte = Class.forName("java.lang.foreign.ValueLayout$OfByte");
            getByte = lookup.findVirtual(MemorySegment, "get", MethodType.methodType(Byte.TYPE, ValueLayout$OfByte, Long.TYPE));
            setByte = lookup.findVirtual(MemorySegment, "set", MethodType.methodType(Void.TYPE, ValueLayout$OfByte, Long.TYPE, Byte.TYPE));
            byteSize = lookup.findVirtual(MemorySegment, "byteSize", MethodType.methodType(Long.TYPE));
            asByteBuffer = lookup.findVirtual(MemorySegment, "asByteBuffer", MethodType.methodType(ByteBuffer.class));
            asSlice = lookup.findVirtual(MemorySegment, "asSlice", MethodType.methodType(MemorySegment, Long.TYPE, Long.TYPE));
            copyFrom = lookup.findVirtual(MemorySegment, "copyFrom", MethodType.methodType(MemorySegment, MemorySegment));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

