/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.bytearray;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.bytearray.AbstractByteArray;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;

public class RandomAccessFileByteArray
extends AbstractByteArray
implements ByteArray,
AutoCloseable {
    private final RandomAccessFile file;
    private final FileChannel channel;
    private final long length;
    private int currentPos = 0;

    public RandomAccessFileByteArray(String path) throws FileNotFoundException {
        this(new File(path));
    }

    public RandomAccessFileByteArray(Path path) throws FileNotFoundException {
        this(path.toFile());
    }

    public RandomAccessFileByteArray(File file) throws FileNotFoundException {
        this(new RandomAccessFile(file, "rw"));
    }

    public RandomAccessFileByteArray(RandomAccessFile file) {
        this.file = file;
        this.channel = file.getChannel();
        try {
            this.length = file.length();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkIndexAndBounds(int idx, int len) {
        if (idx < 0) {
            throw new IllegalArgumentException("index " + idx + " < 0");
        }
        if ((long)idx >= this.length) {
            throw new IllegalArgumentException("index " + idx + " >= length " + this.length);
        }
        if (len < 0) {
            throw new IllegalArgumentException("length " + len + " < 0");
        }
        if ((long)(idx + len) > this.length) {
            throw new IllegalArgumentException("index+len " + (idx + len) + " > length " + this.length);
        }
    }

    private void seek(int pos) throws IOException {
        if (this.currentPos == pos) {
            return;
        }
        this.file.seek(pos);
        this.currentPos = pos;
    }

    @Override
    public byte get(int idx) {
        this.checkIndexAndBounds(idx, 1);
        try {
            this.seek(idx);
            byte res = (byte)this.file.read();
            ++this.currentPos;
            return res;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ByteArray set(int idx, byte value) {
        this.checkIndexAndBounds(idx, 1);
        try {
            this.seek(idx);
            this.file.write(value);
            ++this.currentPos;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public int length() {
        return (int)this.length;
    }

    @Override
    public void byteBufferPut(ByteBuffer dst, int off, int len) {
        this.checkIndexAndBounds(off, len);
        try {
            this.seek(off);
            int oldLim = dst.limit();
            dst.limit(dst.position() + len);
            this.channel.read(dst);
            dst.limit(oldLim);
            this.currentPos += len;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void byteBufferGet(ByteBuffer src, int off, int len) {
        this.checkIndexAndBounds(off, len);
        try {
            this.seek(off);
            int oldLim = src.limit();
            src.limit(src.position() + len);
            this.channel.write(src);
            src.limit(oldLim);
            this.currentPos += len;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doToNewJavaArray(byte[] dst, int dstOff, int srcOff, int srcLen) {
        try {
            this.seek(srcOff);
            this.file.read(dst, dstOff, srcLen);
            this.currentPos += srcLen;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RandomAccessFile getFile() {
        return this.file;
    }

    public FileChannel getChannel() {
        return this.channel;
    }

    @Override
    public void close() throws Exception {
        this.file.close();
    }
}

