/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.bytearray;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.bytearray.AbstractByteArray;
import java.nio.ByteBuffer;

public class SimpleByteArray
extends AbstractByteArray
implements ByteArray {
    private final byte[] array;

    public SimpleByteArray(byte[] array) {
        this.array = array;
    }

    @Override
    public byte get(int idx) {
        this.checkBoundForOffset(idx);
        return this.array[idx];
    }

    @Override
    public ByteArray set(int idx, byte value) {
        this.checkBoundForOffset(idx);
        this.array[idx] = value;
        return this;
    }

    @Override
    public int length() {
        return this.array.length;
    }

    @Override
    public byte[] toJavaArray() {
        return this.array;
    }

    @Override
    public ByteArray arrange() {
        return this;
    }

    @Override
    public void byteBufferPut(ByteBuffer dst, int off, int len) {
        this.checkBoundForByteBufferAndOffsetAndLength(dst, off, len);
        dst.put(this.array, off, len);
    }

    @Override
    public void byteBufferGet(ByteBuffer src, int off, int len) {
        this.checkBoundForByteBufferAndOffsetAndLength(src, off, len);
        src.get(this.array, off, len);
    }

    @Override
    protected void doToNewJavaArray(byte[] dst, int dstOff, int srcOff, int srcLen) {
        System.arraycopy(this.array, srcOff, dst, dstOff, srcLen);
    }
}

