/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.bytearray;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.bytearray.AbstractByteArray;
import java.nio.ByteBuffer;

public class SubByteArray
extends AbstractByteArray
implements ByteArray {
    public final ByteArray source;
    public final int from;
    public final int len;

    private SubByteArray(ByteArray source, int from, int len) {
        this.source = source;
        this.from = from;
        this.len = len;
        if (source.length() - from < len) {
            throw new ArrayIndexOutOfBoundsException("from=" + from + ", len=" + len + ", length=" + source.length());
        }
    }

    public static ByteArray sub(ByteArray source, int from, int len) {
        if (from == 0 && len == source.length()) {
            return source;
        }
        if (!(source instanceof SubByteArray)) {
            return new SubByteArray(source, from, len);
        }
        SubByteArray src = (SubByteArray)source;
        if (src.len < from + len) {
            throw new ArrayIndexOutOfBoundsException("src.len=" + src.len + ", from=" + from + ", len=" + len);
        }
        return new SubByteArray(src.source, src.from + from, len);
    }

    @Override
    public byte get(int idx) {
        this.checkBoundForOffset(idx);
        return this.source.get(idx + this.from);
    }

    @Override
    public ByteArray set(int idx, byte value) {
        this.checkBoundForOffset(idx);
        this.source.set(this.from + idx, value);
        return this;
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public void byteBufferPut(ByteBuffer dst, int off, int len) {
        this.checkBoundForByteBufferAndOffsetAndLength(dst, off, len);
        this.source.byteBufferPut(dst, off + this.from, len);
    }

    @Override
    public void byteBufferGet(ByteBuffer src, int off, int len) {
        this.checkBoundForByteBufferAndOffsetAndLength(src, off, len);
        this.source.byteBufferGet(src, off + this.from, len);
    }

    @Override
    protected void doToNewJavaArray(byte[] dst, int dstOff, int srcOff, int srcLen) {
        ((AbstractByteArray)this.source).doToNewJavaArray(dst, dstOff, this.from + srcOff, srcLen);
    }
}

