/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.callback;

import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Logger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class Callback<T, E extends Throwable> {
    private boolean called = false;

    protected abstract void onSucceeded(T var1);

    protected abstract void onFailed(E var1);

    protected void doFinally() {
    }

    public final boolean isCalled() {
        return this.called;
    }

    public final void succeeded() {
        this.succeeded(null);
    }

    public final void succeeded(T value) {
        if (this.called) {
            Logger.error(LogType.IMPROPER_USE, "callback already called", new Exception("already called when getting result " + value));
            return;
        }
        this.called = true;
        this.onSucceeded(value);
        this.doFinally();
    }

    public final void failed(E err) {
        if (this.called) {
            Logger.error(LogType.IMPROPER_USE, "callback already called", new Exception("already called when getting an exception", (Throwable)err));
            return;
        }
        this.called = true;
        this.onFailed(err);
        this.doFinally();
    }

    public final void finish(E err) {
        this.finish(err, null);
    }

    public final void finish(E err, T value) {
        if (err != null) {
            this.failed(err);
        } else {
            this.succeeded(value);
        }
    }

    public static <T, E extends Throwable> Callback<T, E> ofFunction(final BiConsumer<E, T> cb) {
        return new Callback<T, E>(){

            @Override
            protected void onSucceeded(T value) {
                cb.accept(null, value);
            }

            @Override
            protected void onFailed(E err) {
                cb.accept(err, null);
            }
        };
    }

    public static <T, E extends Throwable> Callback<T, E> ofIgnoreExceptionFunction(final Consumer<T> cb) {
        return new Callback<T, E>(){

            @Override
            protected void onSucceeded(T value) {
                cb.accept(value);
            }

            @Override
            protected void onFailed(E err) {
            }
        };
    }
}

