/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.callback;

import io.vproxy.base.util.callback.Callback;

public class JoinCallback<T, E extends Throwable>
extends Callback<T, E> {
    private final Callback<T, E> cb;
    private final Object lock = this;
    private volatile boolean done = false;
    private volatile Thread waitThread;

    public JoinCallback(Callback<T, E> cb) {
        this.cb = cb;
    }

    @Override
    protected void onSucceeded(T value) {
        this.cb.succeeded(value);
        this.done = true;
        if (this.waitThread != null) {
            this.waitThread.interrupt();
        }
    }

    @Override
    protected void onFailed(E err) {
        this.cb.failed(err);
        this.done = true;
        if (this.waitThread != null) {
            this.waitThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        if (this.done) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.done) {
                return;
            }
            this.waitThread = Thread.currentThread();
        }
        while (!this.done) {
            try {
                Thread.sleep(0x100000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

