/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.coll;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;

public class IntMap<V> {
    private static final int CHUNK_SIZE = 64;
    private final ArrayList<Range> ranges = new ArrayList();
    private final Set<Integer> keySet = new HashSet<Integer>();
    private final LinkedList<V> values = new LinkedList();

    private Range getRange(int n) {
        if (this.ranges.isEmpty()) {
            return null;
        }
        int size = this.ranges.size();
        for (int i = 0; i < size; ++i) {
            Range range = this.ranges.get(i);
            if (!range.contains(n)) continue;
            return range;
        }
        return null;
    }

    public boolean containsKey(int n) {
        Range range = this.getRange(n);
        return range != null && range.get(n) != null;
    }

    public V get(int n) {
        Range range = this.getRange(n);
        if (range == null) {
            return null;
        }
        return range.get(n);
    }

    public V put(int n, V value) {
        if (value == null) {
            throw new IllegalArgumentException("null is not allowed");
        }
        Range range = this.getRange(n);
        if (range != null) {
            return range.put(n, value);
        }
        int initial = n / 64 * 64;
        if (this.ranges.isEmpty() || this.ranges.get((int)(this.ranges.size() - 1)).initial < initial) {
            range = new Range(initial);
            this.ranges.add(range);
            return range.put(n, value);
        }
        if (this.ranges.get((int)0).initial > initial) {
            range = new Range(initial);
            this.ranges.add(0, range);
            return range.put(n, value);
        }
        ListIterator<Range> ite = this.ranges.listIterator();
        while (ite.hasNext()) {
            range = ite.next();
            if (initial <= range.initial) continue;
            ite.previous();
            range = new Range(initial);
            ite.add(range);
            return range.put(n, value);
        }
        throw new Error("should not reach here!!! n=" + n + ", ranges=" + this.ranges);
    }

    public V remove(int n) {
        Range range = this.getRange(n);
        if (range == null) {
            return null;
        }
        Object old = range.remove(n);
        if (range.isEmpty()) {
            this.ranges.remove(range);
        }
        return old;
    }

    public Set<Integer> keySet() {
        return Collections.unmodifiableSet(this.keySet);
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.values);
    }

    private class Range {
        final int initial;
        Object[] array = new Object[64];

        private Range(int initial) {
            this.initial = initial;
        }

        public V get(int index) {
            return this.array[index % 64];
        }

        public V put(int index, V value) {
            int n = index % 64;
            Object old = this.array[n];
            this.array[n] = value;
            IntMap.this.keySet.add(index);
            IntMap.this.values.add(value);
            return old;
        }

        public V remove(int index) {
            int n = index % 64;
            Object old = this.array[n];
            this.array[n] = null;
            IntMap.this.keySet.remove(index);
            IntMap.this.values.remove(old);
            return old;
        }

        public boolean contains(int value) {
            return this.initial <= value && value < this.initial + 64;
        }

        public boolean isEmpty() {
            for (Object o : this.array) {
                if (o == null) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "Range[" + this.initial + ", " + (this.initial + 64) + ")";
        }
    }
}

