/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.coll;

import java.util.Iterator;

public class RingQueue<E>
implements Iterable<E> {
    private Object[] array;
    private boolean eAfterS = true;
    private int start = 0;
    private int end = 0;
    private final ExpandFunction expandFunction;

    public RingQueue() {
        this(16);
    }

    public RingQueue(ExpandFunction e) {
        this(16, e);
    }

    public RingQueue(int initialCapacity) {
        this(initialCapacity, n -> n + 10);
    }

    public RingQueue(int initialCapacity, ExpandFunction e) {
        this.array = new Object[initialCapacity];
        this.expandFunction = e;
    }

    private E get(int idx) {
        return (E)this.array[idx];
    }

    private void expand() {
        int newLen = this.expandFunction.expand(this.array.length);
        Object[] arr = new Object[newLen];
        if (this.eAfterS) {
            System.arraycopy(this.array, this.start, arr, 0, this.end - this.start);
            this.end -= this.start;
        } else {
            System.arraycopy(this.array, this.start, arr, 0, this.array.length - this.start);
            if (this.end > 0) {
                System.arraycopy(this.array, 0, arr, this.array.length - this.start, this.end);
            }
            this.end = this.array.length - this.start + this.end;
        }
        this.start = 0;
        this.array = arr;
        this.eAfterS = true;
    }

    public void clear() {
        this.eAfterS = true;
        this.start = 0;
        this.end = 0;
    }

    public int size() {
        if (this.eAfterS) {
            return this.end - this.start;
        }
        return this.array.length - this.start + this.end;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int currentCapacity() {
        return this.array.length;
    }

    public void add(E e) {
        if (this.eAfterS) {
            this.array[this.end] = e;
            if (this.end == this.array.length - 1) {
                this.end = 0;
                this.eAfterS = false;
            } else {
                ++this.end;
            }
        } else {
            if (this.end == this.start) {
                this.expand();
            }
            this.array[this.end++] = e;
        }
    }

    public E peek() {
        if (this.eAfterS && this.start == this.end) {
            return null;
        }
        return this.get(this.start);
    }

    public E poll() {
        if (this.eAfterS) {
            if (this.start == this.end) {
                return null;
            }
            E e = this.get(this.start++);
            if (this.start == this.end) {
                this.clear();
            }
            return e;
        }
        E e = this.get(this.start);
        if (this.start == this.array.length - 1) {
            this.start = 0;
            this.eAfterS = true;
        } else {
            ++this.start;
        }
        return e;
    }

    public E last() {
        if (this.eAfterS && this.start == this.end) {
            return null;
        }
        if (this.end == 0) {
            return this.get(this.array.length - 1);
        }
        return this.get(this.end - 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean isFirst = true;
        if (this.eAfterS) {
            for (int i = this.start; i < this.end; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(this.array[i]);
            }
        } else {
            int i;
            for (i = this.start; i < this.array.length; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(this.array[i]);
            }
            for (i = 0; i < this.end; ++i) {
                sb.append(", ");
                sb.append(this.array[i]);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Iterator<E> iterator() {
        return new RingQueueIterator();
    }

    private class RingQueueIterator<E>
    implements Iterator<E> {
        private int nextIndex;
        private int step;

        private RingQueueIterator() {
            this.nextIndex = RingQueue.this.start;
            this.step = 0;
        }

        @Override
        public boolean hasNext() {
            if (RingQueue.this.eAfterS) {
                return this.nextIndex < RingQueue.this.end;
            }
            if (this.step == 0) {
                return this.nextIndex < RingQueue.this.array.length;
            }
            return this.nextIndex < RingQueue.this.end;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException();
            }
            Object e = RingQueue.this.array[this.nextIndex];
            ++this.nextIndex;
            if (!RingQueue.this.eAfterS && this.nextIndex == RingQueue.this.array.length) {
                this.step = 1;
                this.nextIndex = 0;
            }
            return (E)e;
        }
    }

    @FunctionalInterface
    public static interface ExpandFunction {
        public int expand(int var1);
    }
}

