/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.coll;

import java.util.Iterator;
import java.util.LinkedList;
import vjson.util.ObjectBuilder;

public class Tree<BRANCH, LEAF> {
    private final LinkedList<Branch<BRANCH, LEAF>> branches = new LinkedList();
    private final LinkedList<Leaf<BRANCH, LEAF>> leaves = new LinkedList();

    public Branch<BRANCH, LEAF> branch(BRANCH data) {
        Branch br = new Branch(this, data);
        this.branches.add(br);
        return br;
    }

    public Leaf<BRANCH, LEAF> leaf(LEAF data) {
        Leaf l = new Leaf(this, data);
        this.leaves.add(l);
        return l;
    }

    public Branch<BRANCH, LEAF> lastBranch() {
        if (this.branches.isEmpty()) {
            return null;
        }
        return this.branches.getLast();
    }

    public Iterable<Branch<BRANCH, LEAF>> branches() {
        return () -> {
            final Iterator ite = this.branches.iterator();
            return new Iterator<Branch<BRANCH, LEAF>>(){

                @Override
                public boolean hasNext() {
                    return ite.hasNext();
                }

                @Override
                public Branch<BRANCH, LEAF> next() {
                    return (Branch)ite.next();
                }
            };
        };
    }

    public Iterable<Leaf<BRANCH, LEAF>> leaves() {
        return () -> {
            final Iterator ite = this.leaves.iterator();
            return new Iterator<Leaf<BRANCH, LEAF>>(){

                @Override
                public boolean hasNext() {
                    return ite.hasNext();
                }

                @Override
                public Leaf<BRANCH, LEAF> next() {
                    return (Leaf)ite.next();
                }
            };
        };
    }

    public Iterable<LEAF> leafData() {
        return () -> {
            final Iterator ite = this.leaves.iterator();
            return new Iterator<LEAF>(){

                @Override
                public boolean hasNext() {
                    return ite.hasNext();
                }

                @Override
                public LEAF next() {
                    return ((Leaf)ite.next()).data;
                }
            };
        };
    }

    public String toString() {
        ObjectBuilder ob = new ObjectBuilder();
        this.buildObject(ob);
        return ob.build().pretty();
    }

    void buildObject(ObjectBuilder ob) {
        ob.putArray("leaves", ab -> {
            for (Leaf leaf : this.leaves) {
                ab.addObject(leaf::buildObject);
            }
        });
        ob.putArray("branches", ab -> {
            for (Branch branch : this.branches) {
                ab.addObject(branch::buildObject);
            }
        });
    }

    public static class Leaf<BRANCH, LEAF> {
        public final Tree<BRANCH, LEAF> parent;
        public final LEAF data;

        Leaf(Tree<BRANCH, LEAF> parent, LEAF data) {
            this.parent = parent;
            this.data = data;
        }

        void buildObject(ObjectBuilder ob) {
            ob.put("data", String.valueOf(this.data));
        }
    }

    public static class Branch<BRANCH, LEAF>
    extends Tree<BRANCH, LEAF> {
        public final Tree<BRANCH, LEAF> parent;
        public final BRANCH data;

        Branch(Tree<BRANCH, LEAF> parent, BRANCH data) {
            this.parent = parent;
            this.data = data;
        }

        @Override
        void buildObject(ObjectBuilder ob) {
            ob.put("data", String.valueOf(this.data));
            super.buildObject(ob);
        }
    }
}

