/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.coll;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakHashSet<E>
implements Set<E> {
    private static final Object _VALUE_ = new Object();
    private final WeakHashMap<E, Object> map = new WeakHashMap();

    public WeakHashSet() {
    }

    public WeakHashSet(Collection<E> callbacks) {
        this.addAll(callbacks);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return new HashSet(this).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return new HashSet(this).toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, _VALUE_) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean b = false;
        for (E e : c) {
            b |= this.add(e);
        }
        return b;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Iterator<E> ite = this.iterator();
        boolean ret = false;
        while (ite.hasNext()) {
            E e = ite.next();
            if (c.contains(e)) continue;
            ite.remove();
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean b = false;
        for (Object o : c) {
            b |= this.remove(o);
        }
        return b;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean isFirst = true;
        for (E e : this.map.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(e);
        }
        sb.append("]");
        return sb.toString();
    }
}

