/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.direct;

import io.vproxy.base.GlobalInspection;
import io.vproxy.base.util.ByteBufferEx;
import io.vproxy.base.util.direct.DirectMemoryUtils;
import java.nio.ByteBuffer;

public class DirectByteBuffer
extends ByteBufferEx {
    private boolean cleaned = false;

    DirectByteBuffer(ByteBuffer buffer) {
        super(buffer);
    }

    @Override
    public ByteBuffer realBuffer() {
        if (this.cleaned) {
            return null;
        }
        return this.buffer;
    }

    @Override
    public void clean() {
        this.clean(true);
    }

    public void clean(boolean tryCache) {
        if (this.cleaned) {
            return;
        }
        this.cleaned = DirectMemoryUtils.free(this, tryCache);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.cleaned) {
                return;
            }
            GlobalInspection.getInstance().directBufferFinalize(this.cap);
        }
        finally {
            super.finalize();
        }
    }
}

