/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.direct;

import io.vproxy.base.GlobalInspection;
import io.vproxy.base.prometheus.Counter;
import io.vproxy.base.prometheus.GaugeF;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.direct.DirectByteBuffer;
import io.vproxy.base.util.objectpool.ConcurrentObjectPool;
import io.vproxy.base.util.unsafe.SunUnsafe;
import java.nio.ByteBuffer;
import java.util.Map;

public class DirectMemoryUtils {
    private static final int BUF_POOL_SIZE = 128;
    private static final ConcurrentObjectPool<DirectByteBuffer> _1 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _2 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _4 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _8 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _16 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _32 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _64 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _128 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _256 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _512 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _1024 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _2048 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _4096 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _8192 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _16384 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _24576 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _32768 = new ConcurrentObjectPool(128);
    private static final ConcurrentObjectPool<DirectByteBuffer> _65536 = new ConcurrentObjectPool(128);
    private static final Counter directMemoryCacheMissCount = GlobalInspection.getInstance().addMetric("direct_memory_cache_miss_count_total", Map.of("type", "buffer"), Counter::new);
    private static final Counter directMemoryCacheHitCount = GlobalInspection.getInstance().addMetric("direct_memory_cache_hit_count_total", Map.of("type", "buffer"), Counter::new);
    private static final Counter directMemoryCacheFailedStoringCount = GlobalInspection.getInstance().addMetric("direct_memory_cache_failed_storing_count_total", Map.of("type", "buffer"), Counter::new);
    private static final Counter directMemoryCacheStoredCount = GlobalInspection.getInstance().addMetric("direct_memory_cache_stored_count_total", Map.of("type", "buffer"), Counter::new);

    private DirectMemoryUtils() {
    }

    private static DirectByteBuffer getBufferCache(int size) {
        switch (size) {
            case 1: {
                return DirectMemoryUtils.getBufferCache(_1);
            }
            case 2: {
                return DirectMemoryUtils.getBufferCache(_2);
            }
            case 4: {
                return DirectMemoryUtils.getBufferCache(_4);
            }
            case 8: {
                return DirectMemoryUtils.getBufferCache(_8);
            }
            case 16: {
                return DirectMemoryUtils.getBufferCache(_16);
            }
            case 32: {
                return DirectMemoryUtils.getBufferCache(_32);
            }
            case 64: {
                return DirectMemoryUtils.getBufferCache(_64);
            }
            case 128: {
                return DirectMemoryUtils.getBufferCache(_128);
            }
            case 256: {
                return DirectMemoryUtils.getBufferCache(_256);
            }
            case 512: {
                return DirectMemoryUtils.getBufferCache(_512);
            }
            case 1024: {
                return DirectMemoryUtils.getBufferCache(_1024);
            }
            case 2048: {
                return DirectMemoryUtils.getBufferCache(_2048);
            }
            case 4096: {
                return DirectMemoryUtils.getBufferCache(_4096);
            }
            case 8192: {
                return DirectMemoryUtils.getBufferCache(_8192);
            }
            case 16384: {
                return DirectMemoryUtils.getBufferCache(_16384);
            }
            case 24576: {
                return DirectMemoryUtils.getBufferCache(_24576);
            }
            case 32768: {
                return DirectMemoryUtils.getBufferCache(_32768);
            }
            case 65536: {
                return DirectMemoryUtils.getBufferCache(_65536);
            }
        }
        return null;
    }

    private static DirectByteBuffer getBufferCache(ConcurrentObjectPool<DirectByteBuffer> buffers) {
        DirectByteBuffer buf = buffers.poll();
        if (buf == null) {
            directMemoryCacheMissCount.incr(1L);
        } else {
            directMemoryCacheHitCount.incr(1L);
        }
        return buf;
    }

    private static boolean releaseBufferCache(DirectByteBuffer buf) {
        switch (buf.capacity()) {
            case 1: {
                return DirectMemoryUtils.releaseBufferCache(_1, buf);
            }
            case 2: {
                return DirectMemoryUtils.releaseBufferCache(_2, buf);
            }
            case 4: {
                return DirectMemoryUtils.releaseBufferCache(_4, buf);
            }
            case 8: {
                return DirectMemoryUtils.releaseBufferCache(_8, buf);
            }
            case 16: {
                return DirectMemoryUtils.releaseBufferCache(_16, buf);
            }
            case 32: {
                return DirectMemoryUtils.releaseBufferCache(_32, buf);
            }
            case 64: {
                return DirectMemoryUtils.releaseBufferCache(_64, buf);
            }
            case 128: {
                return DirectMemoryUtils.releaseBufferCache(_128, buf);
            }
            case 256: {
                return DirectMemoryUtils.releaseBufferCache(_256, buf);
            }
            case 512: {
                return DirectMemoryUtils.releaseBufferCache(_512, buf);
            }
            case 1024: {
                return DirectMemoryUtils.releaseBufferCache(_1024, buf);
            }
            case 2048: {
                return DirectMemoryUtils.releaseBufferCache(_2048, buf);
            }
            case 4096: {
                return DirectMemoryUtils.releaseBufferCache(_4096, buf);
            }
            case 8192: {
                return DirectMemoryUtils.releaseBufferCache(_8192, buf);
            }
            case 16384: {
                return DirectMemoryUtils.releaseBufferCache(_16384, buf);
            }
            case 24576: {
                return DirectMemoryUtils.releaseBufferCache(_24576, buf);
            }
            case 32768: {
                return DirectMemoryUtils.releaseBufferCache(_32768, buf);
            }
            case 65536: {
                return DirectMemoryUtils.releaseBufferCache(_65536, buf);
            }
        }
        return false;
    }

    private static boolean releaseBufferCache(ConcurrentObjectPool<DirectByteBuffer> buffers, DirectByteBuffer buf) {
        boolean ret = buffers.add(buf);
        if (ret) {
            directMemoryCacheStoredCount.incr(1L);
        } else {
            directMemoryCacheFailedStoringCount.incr(1L);
        }
        return ret;
    }

    public static DirectByteBuffer allocateDirectBuffer(int size) {
        DirectByteBuffer directByteBuffer = DirectMemoryUtils.getBufferCache(size);
        if (directByteBuffer != null) {
            assert (Logger.lowLevelDebug("cached direct buffer retrieved: " + size));
            directByteBuffer.limit(directByteBuffer.capacity()).position(0);
            return directByteBuffer;
        }
        ByteBuffer buf = ByteBuffer.allocateDirect(size);
        GlobalInspection.getInstance().directBufferAllocate(buf.capacity());
        return new DirectByteBuffer(buf);
    }

    static boolean free(DirectByteBuffer buffer, boolean tryCache) {
        boolean succeeded;
        assert (Logger.lowLevelDebug("run DirectMemoryUtils.free"));
        if (!buffer.realBuffer().isDirect()) {
            assert (Logger.lowLevelDebug("not direct buffer"));
            return true;
        }
        if (tryCache && (succeeded = DirectMemoryUtils.releaseBufferCache(buffer))) {
            assert (Logger.lowLevelDebug("direct buffer cached: " + buffer.capacity()));
            return false;
        }
        assert (Logger.lowLevelDebug("is direct buffer, do clean"));
        GlobalInspection.getInstance().directBufferFree(buffer.capacity());
        SunUnsafe.invokeCleaner(buffer.realBuffer());
        return true;
    }

    static {
        GlobalInspection.getInstance().registerHelpMessage("direct_memory_cache_miss_count_total", "Total cache miss of direct memory");
        GlobalInspection.getInstance().registerHelpMessage("direct_memory_cache_hit_count_total", "Total cache hit of direct memory");
        GlobalInspection.getInstance().registerHelpMessage("direct_memory_cache_failed_storing_count_total", "Total failed storing direct memory cache times");
        GlobalInspection.getInstance().registerHelpMessage("direct_memory_cache_stored_count_total", "Total stored direct memory cache times");
        GlobalInspection.getInstance().registerHelpMessage("cached_direct_memory_count_current", "Current cached direct memory in bytes");
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "1"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _1.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "2"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _2.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "4"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _4.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "8"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _8.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "16"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _16.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "32"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _32.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "64"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _64.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "128"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _128.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "256"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _256.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "512"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _512.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "1024"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _1024.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "2048"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _2048.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "4096"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _4096.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "8192"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _8192.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "16384"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _16384.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "24576"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _24576.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "32768"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _32768.size()));
        GlobalInspection.getInstance().addMetric("cached_direct_memory_count_current", Map.of("type", "buffer", "size_in_bytes", "65536"), (s, m) -> new GaugeF((String)s, (Map<String, String>)m, () -> _65536.size()));
    }
}

