/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.display;

import io.vproxy.base.util.coll.Tree;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TreeBuilder {
    private int indentation = 6;
    private final Tree<String, String> tree = new Tree();

    public void setIndentation(int indentation) {
        this.indentation = indentation;
    }

    public BranchBuilder branch(String data) {
        return new BranchBuilder(this.tree.branch(data));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("o").append("\n");
        LinkedList<ToStringHelper> indents = new LinkedList<ToStringHelper>();
        indents.add(new ToStringHelper(0));
        this.toStringBranches(sb, indents, this.tree.branches().iterator());
        return sb.toString();
    }

    private void toStringBranches(StringBuilder sb, LinkedList<ToStringHelper> helpers, Iterator<Tree.Branch<String, String>> branches) {
        while (branches.hasNext()) {
            Tree.Branch<String, String> br = branches.next();
            this.appendIndent(sb, helpers);
            sb.append((String)br.data).append("\n");
            if (!branches.hasNext()) {
                helpers.getLast().show = false;
            }
            helpers.add(new ToStringHelper(helpers.getLast().indent + this.indentation));
            this.toStringBranches(sb, helpers, br.branches().iterator());
            this.toStringLeaves(sb, helpers, br.leaves().iterator());
            helpers.removeLast();
        }
    }

    private void toStringLeaves(StringBuilder sb, LinkedList<ToStringHelper> helpers, Iterator<Tree.Leaf<String, String>> leaves) {
        while (leaves.hasNext()) {
            Tree.Leaf<String, String> leaf = leaves.next();
            this.appendIndent(sb, helpers);
            sb.append((String)leaf.data);
            sb.append("\n");
        }
    }

    private void appendIndent(StringBuilder sb, List<ToStringHelper> helpers) {
        this.appendIndent0(sb, helpers);
        sb.append("\n");
        this.appendIndent0(sb, helpers);
        sb.delete(sb.length() - 1, sb.length());
        sb.append("+");
        sb.append("-".repeat(this.indentation - 3));
        sb.append("> ");
    }

    private void appendIndent0(StringBuilder sb, List<ToStringHelper> helpers) {
        int lastIndent = -1;
        Iterator<ToStringHelper> iterator = helpers.iterator();
        while (iterator.hasNext()) {
            ToStringHelper h = iterator.next();
            if (lastIndent != -1) {
                sb.append(" ".repeat(h.indent - lastIndent - 1));
            }
            lastIndent = h.indent;
            if (h.show || !iterator.hasNext()) {
                sb.append("|");
                continue;
            }
            sb.append(" ");
        }
    }

    private static class ToStringHelper {
        final int indent;
        boolean show = true;

        private ToStringHelper(int indent) {
            this.indent = indent;
        }
    }

    public static class BranchBuilder {
        private final Tree.Branch<String, String> branch;

        public BranchBuilder(Tree.Branch<String, String> branch) {
            this.branch = branch;
        }

        public BranchBuilder branch(String data) {
            return new BranchBuilder(this.branch.branch(data));
        }

        public void leaf(String data) {
            this.branch.leaf(data);
        }
    }
}

