/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.file;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.callback.Callback;
import io.vproxy.base.util.coll.Tuple;
import io.vproxy.base.util.promise.Promise;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;

public class MappedByteBufferLogger {
    private final String prefix;
    private final String suffix;
    private final long size;
    private final long preNewFileThreshold;
    private int fileNameIndex = 0;
    private MappedByteBuffer current;
    private volatile Tuple<Promise<Void>, Callback<Void, Throwable>> futureTuple = null;
    private volatile MappedByteBuffer newBuffer;
    private volatile IOException fileCreationTaskFailureException = null;

    public MappedByteBufferLogger(String location, String prefix, String suffix, long size, long preNewFileThreshold) throws IOException {
        assert (size > preNewFileThreshold);
        assert (size > 0L);
        assert (preNewFileThreshold >= 0L);
        if (!new File(location).isDirectory()) {
            throw new IOException(location + " is not a directory");
        }
        this.prefix = new File(location).getCanonicalPath() + File.separator + prefix;
        this.suffix = suffix;
        this.size = size;
        this.preNewFileThreshold = preNewFileThreshold;
        this.newFile();
        this.handleTaskResultAndReplaceBuffers();
    }

    private String nextFileNameIndex() {
        int n;
        String s;
        if ((s = "" + (n = this.fileNameIndex++)).length() < 4) {
            s = "0".repeat(4 - s.length()) + s;
        }
        return s;
    }

    private void newFile() throws IOException {
        File file = new File(this.prefix + this.nextFileNameIndex() + this.suffix);
        file.createNewFile();
        try (RandomAccessFile rfile = new RandomAccessFile(file, "rw");){
            rfile.setLength(this.size);
        }
        try (FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            this.newBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, this.size);
        }
    }

    private Promise<Void> prepareNewFile() {
        if (this.futureTuple != null) {
            return (Promise)this.futureTuple._1;
        }
        if (this.newBuffer != null) {
            return null;
        }
        if (this.fileCreationTaskFailureException != null) {
            return null;
        }
        return this.doStartNewFileTask();
    }

    private Promise<Void> doStartNewFileTask() {
        Tuple tuple = Promise.todo();
        this.futureTuple = tuple;
        new Thread(() -> {
            try {
                this.newFile();
            }
            catch (IOException e) {
                this.fileCreationTaskFailureException = e;
            }
            finally {
                this.futureTuple = null;
            }
            if (this.fileCreationTaskFailureException != null) {
                ((Callback)tuple._2).failed(this.fileCreationTaskFailureException);
            } else {
                ((Callback)tuple._2).succeeded();
            }
        }).start();
        return (Promise)tuple._1;
    }

    private void blockOnNewFileTask() throws IOException {
        Tuple<Promise<Void>, Callback<Void, Throwable>> tuple = this.futureTuple;
        if (tuple != null) {
            this.waitForTask(tuple);
            return;
        }
        if (this.newBuffer != null || this.fileCreationTaskFailureException != null) {
            this.handleTaskResultAndReplaceBuffers();
            return;
        }
        try {
            this.newFile();
        }
        catch (IOException e) {
            this.close();
            Logger.error(LogType.FILE_ERROR, "failed creating new file for " + this.prefix + "..." + this.suffix);
            throw e;
        }
        this.handleTaskResultAndReplaceBuffers();
    }

    private void waitForTask(Tuple<Promise<Void>, Callback<Void, Throwable>> tuple) throws IOException {
        try {
            ((Promise)tuple._1).block();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
        this.handleTaskResultAndReplaceBuffers();
    }

    private void handleTaskResultAndReplaceBuffers() throws IOException {
        if (this.fileCreationTaskFailureException != null) {
            IOException e = this.fileCreationTaskFailureException;
            this.fileCreationTaskFailureException = null;
            throw e;
        }
        if (this.current != null) {
            MappedByteBuffer current = this.current;
            new Thread(current::force).start();
        }
        this.current = this.newBuffer;
        this.newBuffer = null;
    }

    private boolean newFileTaskDone() {
        return this.futureTuple == null && (this.newBuffer != null || this.fileCreationTaskFailureException != null);
    }

    public WriteOrDropResult writeOrDrop(String s) throws IOException {
        return this.writeOrDrop(ByteArray.from(s));
    }

    public WriteOrDropResult writeOrDrop(ByteArray data) throws IOException {
        if (this.current == null) {
            throw new IllegalStateException("closed");
        }
        if ((long)data.length() > 2L * this.size) {
            return new WriteOrDropResult(WriteOrDropResultType.DROP_TOO_LARGE, null);
        }
        if ((long)data.length() > this.size) {
            if ((long)data.length() > this.size + (long)this.current.limit() - (long)this.current.position()) {
                if (this.newFileTaskDone()) {
                    this.handleTaskResultAndReplaceBuffers();
                }
                Promise<Void> promise = this.prepareNewFile();
                return new WriteOrDropResult(WriteOrDropResultType.DROP_PENDING, promise);
            }
            if (!this.newFileTaskDone()) {
                Promise<Void> promise = this.prepareNewFile();
                return new WriteOrDropResult(WriteOrDropResultType.DROP_PENDING, promise);
            }
        } else if (this.current.limit() - this.current.position() < data.length() && !this.newFileTaskDone()) {
            Promise<Void> promise = this.prepareNewFile();
            return new WriteOrDropResult(WriteOrDropResultType.DROP_PENDING, promise);
        }
        this.writeAndBlock(data);
        return new WriteOrDropResult(WriteOrDropResultType.WRITTEN, null);
    }

    public void writeAndBlock(String s) throws IOException {
        this.writeAndBlock(ByteArray.from(s));
    }

    public void writeAndBlock(ByteArray data) throws IOException {
        if (this.current == null) {
            throw new IllegalStateException("closed");
        }
        if ((long)data.length() > this.size) {
            int split = this.current.limit() - this.current.position();
            if (split <= 0) {
                split = (int)this.size;
            }
            ByteArray left = data.sub(0, split);
            ByteArray right = data.sub(split, data.length() - split);
            this.writeAndBlock(left);
            this.writeAndBlock(right);
            return;
        }
        if (this.current.limit() - this.current.position() < data.length()) {
            this.blockOnNewFileTask();
            this.writeAndBlock(data);
            return;
        }
        this.current.put(data.toJavaArray());
        if ((long)(this.current.limit() - this.current.position()) <= this.preNewFileThreshold) {
            this.prepareNewFile();
        }
    }

    public void close() {
        this.close(false);
    }

    public void closeAndFlushOnNewThread() {
        this.close(true);
    }

    private void close(boolean flushOnNewThread) {
        if (this.current != null) {
            if (flushOnNewThread) {
                MappedByteBuffer current = this.current;
                new Thread(current::force).start();
            } else {
                this.current.force();
            }
        }
        this.current = null;
        this.newBuffer = null;
        this.fileCreationTaskFailureException = null;
    }

    public static enum WriteOrDropResultType {
        WRITTEN,
        DROP_PENDING,
        DROP_TOO_LARGE;


        public boolean isDropped() {
            return this != WRITTEN;
        }

        public boolean isWritten() {
            return this == WRITTEN;
        }
    }

    public static final class WriteOrDropResult {
        private final WriteOrDropResultType type;
        private final Promise<Void> writablePromise;

        public WriteOrDropResult(WriteOrDropResultType type, Promise<Void> writablePromise) {
            this.type = type;
            this.writablePromise = writablePromise;
        }

        public WriteOrDropResultType type() {
            return this.type;
        }

        public Promise<Void> writablePromise() {
            return this.writablePromise;
        }
    }
}

