/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.log;

import io.vproxy.base.util.coll.CopyOnWriteHolder;
import io.vproxy.base.util.coll.WeakHashSet;
import io.vproxy.base.util.log.LogHandler;
import io.vproxy.base.util.log.LogRecord;

public class LogDispatcher {
    private final CopyOnWriteHolder<WeakHashSet<LogHandler>> callbacks = new CopyOnWriteHolder<WeakHashSet>(new WeakHashSet(), WeakHashSet::new);

    public synchronized void addLogHandler(LogHandler listener) {
        this.callbacks.update(set -> set.add(listener));
    }

    public synchronized void removeLogHandler(LogHandler listener) {
        this.callbacks.update(set -> set.remove(listener));
    }

    public void publish(LogRecord record) {
        for (LogHandler s : this.callbacks.get()) {
            s.publish(record);
        }
    }
}

