/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.log;

import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Utils;
import io.vproxy.base.util.log.LogLevel;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LogRecord {
    public final String threadName;
    public final StackTraceElement stackInfo;
    public final LogLevel level;
    public final LogType type;
    public final long ts;
    public final String content;
    public final Throwable ex;
    private String generatedColorString;
    private String generatedPlainString;
    private String fullStackTrace;
    private String simpleStackTrace;

    public LogRecord(String threadName, StackTraceElement stackInfo, LogLevel level, LogType type, long ts, String content, Throwable ex) {
        this.threadName = threadName;
        this.stackInfo = stackInfo;
        this.level = level;
        this.type = type;
        this.ts = ts;
        this.content = content;
        this.ex = ex;
    }

    public String toString() {
        return this.toColoredString();
    }

    public String toColoredString() {
        return this.toColoredString(false);
    }

    public String toColoredString(boolean stackTraceOn) {
        if (this.generatedColorString == null) {
            this.generatedColorString = this.toString(true);
        }
        return this.generatedColorString + this.exToString(stackTraceOn);
    }

    public String toStringNoColor() {
        return this.toStringNoColor(false);
    }

    public String toStringNoColor(boolean stackTraceOn) {
        if (this.generatedPlainString == null) {
            this.generatedPlainString = this.toString(false);
        }
        return this.generatedPlainString + this.exToString(stackTraceOn);
    }

    private String toString(boolean withColor) {
        StringBuilder sb = new StringBuilder();
        if (withColor) {
            sb.append(this.level.color);
        }
        sb.append("[").append(Utils.formatTimestampForLogging(this.ts)).append("]");
        sb.append("[").append((Object)this.level).append("] - ");
        if (this.threadName != null) {
            sb.append(this.threadName);
            sb.append(" - ");
            if (this.stackInfo != null) {
                sb.append(this.stackInfo.getClassName()).append("#").append(this.stackInfo.getMethodName()).append("(").append(this.stackInfo.getLineNumber()).append(") - ");
            }
        }
        if (this.type != null) {
            sb.append((Object)this.type).append(" - ");
        }
        if (withColor) {
            sb.append("\u001b[0m");
        }
        sb.append(this.content);
        return sb.toString();
    }

    private String exToString(boolean stackTraceOn) {
        if (this.ex == null) {
            return "";
        }
        if (stackTraceOn || this.ex instanceof RuntimeException) {
            if (this.fullStackTrace == null) {
                this.fullStackTrace = "\n" + LogRecord.privateFormatStackTrace(true, this.ex);
            }
            return this.fullStackTrace;
        }
        if (this.simpleStackTrace == null) {
            this.simpleStackTrace = "\n" + LogRecord.privateFormatStackTrace(false, this.ex);
        }
        return this.simpleStackTrace;
    }

    private static String privateFormatStackTrace(boolean stackTraceOn, Throwable t) {
        if (stackTraceOn || !(t instanceof Exception) || t instanceof RuntimeException) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            return sw.toString();
        }
        StringBuilder sb = new StringBuilder();
        LogRecord.formatExceptionStackTrace(t, sb);
        return sb.toString();
    }

    private static void formatExceptionStackTrace(Throwable t, StringBuilder sb) {
        String msg = t.getMessage();
        if (msg == null || msg.isBlank()) {
            sb.append(t.getClass().getName());
        } else {
            sb.append(t.getClass().getName()).append(": ").append(msg.trim());
        }
        if (t.getCause() != null) {
            sb.append(" <= ");
            LogRecord.formatExceptionStackTrace(t.getCause(), sb);
        }
    }
}

