/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.net;

import io.vproxy.base.util.coll.Tuple;
import io.vproxy.base.util.net.PortPool;
import io.vproxy.vfd.IP;
import io.vproxy.vfd.IPPort;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import vjson.parser.ParserUtils;

public class IPPortPool {
    private final ArrayList<Tuple<IP, PortPool>> pool = new ArrayList();
    private final Map<IP, PortPool> poolMap = new HashMap<IP, PortPool>();
    private int cursor = 0;

    /*
     * WARNING - void declaration
     */
    public IPPortPool(String expr) {
        void var6_8;
        ArrayList<String> configs = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        char[] cArray = expr.toCharArray();
        int n = cArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            char c = cArray[var6_8];
            if (!ParserUtils.isWhiteSpace((char)c)) {
                if (c == '\r' || c == '\n' || c == '|' || c == '/') {
                    String s = sb.toString();
                    sb.delete(0, sb.length());
                    if (!s.isBlank()) {
                        configs.add(s.trim());
                    }
                } else {
                    sb.append(c);
                }
            }
            ++var6_8;
        }
        if (!sb.toString().isBlank()) {
            configs.add(sb.toString().trim());
        }
        HashSet<IP> ips = new HashSet<IP>();
        for (String string : configs) {
            PortPool portPool;
            int colonIndex = string.lastIndexOf(":");
            if (colonIndex == -1) {
                throw new IllegalArgumentException("invalid config: no colon: " + string);
            }
            if (colonIndex == string.length() - 1) {
                throw new IllegalArgumentException("invalid config: missing port ranges: " + string);
            }
            if (colonIndex == 0) {
                throw new IllegalArgumentException("invalid config: missing ip: " + string);
            }
            String ipStr = string.substring(0, colonIndex);
            if (!IP.isIpLiteral(ipStr)) {
                throw new IllegalArgumentException("invalid config: " + ipStr + " is not a valid ip: " + ipStr);
            }
            IP ip = IP.from(ipStr);
            if (!ips.add(ip)) {
                throw new IllegalArgumentException("duplicated ip: " + ip.formatToIPString() + ": " + ipStr);
            }
            String portExp = string.substring(colonIndex + 1);
            try {
                portPool = new PortPool(portExp);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("invalid config when parsing port expression: " + e.getMessage() + ": " + ipStr);
            }
            this.pool.add(new Tuple<IP, PortPool>(ip, portPool));
        }
        for (Tuple tuple : this.pool) {
            this.poolMap.put((IP)tuple._1, (PortPool)tuple._2);
        }
    }

    private void nextCursor() {
        block0: {
            int c;
            if ((c = this.cursor++) + 1 < this.pool.size()) break block0;
            this.cursor = 0;
        }
    }

    public IPPort allocate() {
        for (int i = 0; i < this.pool.size(); ++i) {
            Tuple<IP, PortPool> tuple = this.pool.get(this.cursor);
            int port = ((PortPool)tuple._2).allocate();
            if (port != 0) {
                return new IPPort((IP)tuple._1, port);
            }
            this.nextCursor();
        }
        return null;
    }

    public void release(IPPort ipport) {
        PortPool pool = this.poolMap.get(ipport.getAddress());
        if (pool == null) {
            throw new IllegalArgumentException("not within this pool");
        }
        pool.release(ipport.getPort());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPPortPool that = (IPPortPool)o;
        return this.pool.equals(that.pool);
    }

    public int hashCode() {
        return Objects.hash(this.pool);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Tuple<IP, PortPool> tup : this.pool) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("/");
            }
            sb.append(((IP)tup._1).formatToIPString()).append(":").append(((PortPool)tup._2).toString());
        }
        return sb.toString();
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Tuple<IP, PortPool> tup : this.pool) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("/");
            }
            sb.append(((IP)tup._1).formatToIPString()).append(":").append(((PortPool)tup._2).serialize());
        }
        return sb.toString();
    }
}

