/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.net;

import io.vproxy.base.connection.Protocol;
import io.vproxy.base.util.net.IPPortPool;
import io.vproxy.vfd.IPPort;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SNatIPPortPool {
    private final IPPortPool pool;
    private final Set<Tuple> ctSet = new HashSet<Tuple>();
    private final Map<IPPort, Ref> srcRefMap = new HashMap<IPPort, Ref>();
    private final ArrayList<IPPort> srcList = new ArrayList();

    public SNatIPPortPool(String expression) {
        this.pool = new IPPortPool(expression);
    }

    public IPPort allocate(Protocol protocol, IPPort target) {
        Tuple tuple = new Tuple();
        if (protocol == Protocol.TCP) {
            tuple.proto = 6;
        } else if (protocol == Protocol.UDP) {
            tuple.proto = 17;
        } else {
            throw new IllegalArgumentException("unsupported protocol " + protocol);
        }
        tuple.dst = target;
        IPPort selected = null;
        for (int i = this.srcList.size() - 1; i >= 0; --i) {
            IPPort src;
            tuple.src = src = this.srcList.get(i);
            tuple.clearHash();
            if (this.ctSet.contains(tuple)) continue;
            selected = src;
            break;
        }
        if (selected == null && (selected = this.pool.allocate()) != null) {
            tuple.src = selected;
            tuple.clearHash();
            this.srcList.add(selected);
        }
        if (selected == null) {
            return null;
        }
        Ref ref = this.srcRefMap.get(selected);
        if (ref == null) {
            ref = new Ref();
            this.srcRefMap.put(selected, ref);
        }
        ++ref.ref;
        tuple.srcRef = ref;
        this.ctSet.add(tuple);
        return selected;
    }

    public void release(Protocol protocol, IPPort src, IPPort dst) {
        Tuple tuple = new Tuple();
        if (protocol == Protocol.TCP) {
            tuple.proto = 6;
        } else if (protocol == Protocol.UDP) {
            tuple.proto = 17;
        } else {
            throw new IllegalArgumentException("unsupported protocol " + protocol);
        }
        tuple.src = src;
        tuple.dst = dst;
        boolean removed = this.ctSet.remove(tuple);
        if (!removed) {
            return;
        }
        Ref ref = this.srcRefMap.get(src);
        if (ref == null) {
            return;
        }
        --ref.ref;
        if (ref.ref != 0) {
            return;
        }
        this.srcRefMap.remove(src);
        this.srcList.remove(src);
        this.pool.release(src);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SNatIPPortPool that = (SNatIPPortPool)o;
        return this.pool.equals(that.pool);
    }

    public int hashCode() {
        return Objects.hash(this.pool);
    }

    public String serialize() {
        return this.pool.serialize();
    }

    public String toString() {
        return "SNatIPPortPool{pool=" + this.pool + ", ctSet=" + this.ctSet + ", srcRefMap=" + this.srcRefMap + ", srcList=" + this.srcList + "}@" + Integer.toHexString(super.hashCode());
    }

    private static final class Ref {
        int ref = 0;

        private Ref() {
        }

        public String toString() {
            return "{" + this.ref + "}@" + Integer.toHexString(super.hashCode());
        }
    }

    private static final class Tuple {
        int proto;
        IPPort src;
        IPPort dst;
        Ref srcRef;
        int hash;

        private Tuple() {
        }

        void clearHash() {
            this.hash = 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tuple tuple = (Tuple)o;
            return this.proto == tuple.proto && this.src.equals(tuple.src) && this.dst.equals(tuple.dst);
        }

        public int hashCode() {
            if (this.hash != 0) {
                return this.hash;
            }
            this.hash = Objects.hash(this.proto, this.src, this.dst);
            return this.hash;
        }

        public String toString() {
            return "{" + this.proto + "/" + this.src + "/" + this.dst + "/ref=" + this.srcRef + "}";
        }
    }
}

