/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.nio;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.Utils;
import io.vproxy.vfd.ReadableByteStream;
import io.vproxy.vfd.WritableByteStream;
import java.nio.ByteBuffer;

public class ByteArrayChannel
implements ReadableByteStream,
WritableByteStream {
    private final ByteArray arr;
    private int writeOff;
    private int writeLen;
    private int readOff;
    private final int initialWriteOff;
    private final int initialWriteLen;
    private final int initialReadOff;

    private ByteArrayChannel(ByteArray arr, int readOff, int writeOff, int writeLen) {
        this.arr = arr;
        if (arr.length() == 0 || readOff >= arr.length() || readOff < 0 || writeOff < 0 || writeOff > arr.length() || writeLen < 0 || writeOff + writeLen > arr.length()) {
            throw new IllegalArgumentException();
        }
        this.initialWriteOff = writeOff;
        this.initialWriteLen = writeLen;
        this.initialReadOff = readOff;
        this.reset();
    }

    private ByteArrayChannel() {
        this.arr = ByteArray.allocate(0);
        this.initialWriteOff = 0;
        this.initialWriteLen = 0;
        this.initialReadOff = 0;
    }

    public static ByteArrayChannel fromEmpty(int len) {
        return new ByteArrayChannel(ByteArray.allocate(len), 0, 0, len);
    }

    public static ByteArrayChannel fromEmpty(byte[] arr) {
        return new ByteArrayChannel(ByteArray.from(arr), 0, 0, arr.length);
    }

    public static ByteArrayChannel fromFull(byte[] arr) {
        return new ByteArrayChannel(ByteArray.from(arr), 0, arr.length, 0);
    }

    public static ByteArrayChannel from(byte[] arr, int readOff, int writeOff, int writeLen) {
        return ByteArrayChannel.from(ByteArray.from(arr), readOff, writeOff, writeLen);
    }

    public static ByteArrayChannel from(ByteArray arr, int readOff, int writeOff, int writeLen) {
        return new ByteArrayChannel(arr, readOff, writeOff, writeLen);
    }

    public static ByteArrayChannel fromFull(ByteArray arr) {
        return new ByteArrayChannel(arr, 0, arr.length(), 0);
    }

    public static ByteArrayChannel zero() {
        return new ByteArrayChannel();
    }

    @Override
    public int read(ByteBuffer dst) {
        int readLen = this.writeOff - this.readOff;
        int readBytes = Math.min(readLen, dst.limit() - dst.position());
        this.arr.byteBufferPut(dst, this.readOff, readBytes);
        this.readOff += readBytes;
        return readBytes;
    }

    public byte read() {
        if (this.writeOff - this.readOff == 0) {
            throw new IndexOutOfBoundsException("readOff=" + this.readOff + ", writeOff=" + this.writeOff);
        }
        return this.arr.get(this.readOff++);
    }

    public void skip(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n = " + n + " < 0");
        }
        if (this.readOff + n > this.writeOff) {
            throw new IndexOutOfBoundsException("readOff + n = " + this.readOff + " + " + n + " = " + (this.readOff + n) + " > writeOff(" + this.writeOff + ")");
        }
        this.readOff += n;
    }

    @Override
    public int write(ByteBuffer src) {
        int writeBytes = Math.min(this.writeLen, src.limit() - src.position());
        this.arr.byteBufferGet(src, this.writeOff, writeBytes);
        this.writeOff += writeBytes;
        this.writeLen -= writeBytes;
        return writeBytes;
    }

    public int write(ByteArrayChannel src) {
        return this.write(src, src.used());
    }

    public int write(ByteArrayChannel src, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("len = " + len + " < 0");
        }
        if (src.used() < len) {
            throw new IndexOutOfBoundsException("src.used = " + src.used() + ", len = " + len + " < 0");
        }
        int writeBytes = Math.min(this.writeLen, len);
        ByteBuffer tmp = Utils.allocateByteBuffer(len);
        src.read(tmp);
        tmp.flip();
        this.arr.byteBufferGet(tmp, this.writeOff, writeBytes);
        this.writeOff += writeBytes;
        this.writeLen -= writeBytes;
        return writeBytes;
    }

    public int free() {
        return this.writeLen;
    }

    public int used() {
        return this.writeOff - this.readOff;
    }

    public void reset() {
        this.writeOff = this.initialWriteOff;
        this.writeLen = this.initialWriteLen;
        this.readOff = this.initialReadOff;
    }

    public byte[] getBytes() {
        return this.getArray().toJavaArray();
    }

    public ByteArray readableArray() {
        int off = this.readOff;
        int len = this.writeOff - this.readOff;
        if (off == 0 && len == this.arr.length()) {
            return this.arr;
        }
        return this.arr.sub(off, len);
    }

    public ByteArray readAll() {
        ByteArray arr = this.readableArray();
        this.readOff = this.writeOff;
        return arr;
    }

    public ByteArray getArray() {
        int off = this.initialReadOff;
        int len = this.initialWriteOff + this.initialWriteLen - this.initialReadOff;
        if (off == 0 && len == this.arr.length()) {
            return this.arr;
        }
        return this.arr.sub(off, len);
    }

    public int getWriteOff() {
        return this.writeOff - this.initialReadOff;
    }

    public int getWriteLen() {
        return this.writeLen - this.initialReadOff;
    }

    public int getReadOff() {
        return this.readOff - this.initialReadOff;
    }

    public void setReadOff(int readOff) {
        if (readOff < 0) {
            throw new IllegalArgumentException();
        }
        if (readOff > this.getWriteOff()) {
            throw new IllegalArgumentException();
        }
        this.readOff = this.initialReadOff + readOff;
    }

    public String toString() {
        return "ByteArrayChannel:" + this.arr.getClass().getSimpleName() + "(" + this.arr.sub(this.readOff, this.writeOff - this.readOff).toString().replaceAll("\\r|\\n", ".") + ")";
    }
}

