/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.objectpool;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class ConcurrentObjectPool<E> {
    private final int partitionCount;
    private final Partition<E>[] partitions;

    public ConcurrentObjectPool(int capacityHint) {
        this(capacityHint, 16, 4);
    }

    public ConcurrentObjectPool(int capacityHint, int partitionCountHint, int minPartitionCapHint) {
        --capacityHint;
        capacityHint |= capacityHint >>> 1;
        capacityHint |= capacityHint >>> 2;
        capacityHint |= capacityHint >>> 4;
        capacityHint |= capacityHint >>> 8;
        capacityHint |= capacityHint >>> 16;
        this.partitionCount = ++capacityHint / minPartitionCapHint == 0 ? 1 : Math.min(capacityHint / minPartitionCapHint, partitionCountHint);
        this.partitions = new Partition[this.partitionCount];
        for (int i = 0; i < this.partitionCount; ++i) {
            this.partitions[i] = new Partition(capacityHint / this.partitionCount);
        }
    }

    public boolean add(E e) {
        for (int i = 0; i < this.partitionCount; ++i) {
            if (!this.partitions[i].add(e)) continue;
            return true;
        }
        return false;
    }

    public E poll() {
        for (int i = 0; i < this.partitionCount; ++i) {
            E e = this.partitions[i].poll();
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.partitionCount; ++i) {
            size += this.partitions[i].size();
        }
        return size;
    }

    private static class StorageArray<E> {
        private final int capacity;
        private final AtomicReferenceArray<E> array;
        private final AtomicInteger start = new AtomicInteger(0);
        private final AtomicInteger endIndicator = new AtomicInteger(0);
        private final AtomicInteger end = new AtomicInteger(0);

        private StorageArray(int capacity) {
            this.capacity = capacity;
            this.array = new AtomicReferenceArray(capacity);
        }

        boolean add(E e) {
            if (this.end.get() >= this.capacity || this.endIndicator.get() >= this.capacity) {
                return false;
            }
            int index = this.endIndicator.getAndIncrement();
            if (index < this.capacity) {
                this.array.set(index, e);
                this.end.getAndIncrement();
                return true;
            }
            this.endIndicator.getAndDecrement();
            return false;
        }

        E poll() {
            if (this.start.get() >= this.end.get()) {
                return null;
            }
            int idx = this.start.getAndIncrement();
            if (idx >= this.end.get()) {
                return null;
            }
            return this.array.get(idx);
        }

        int size() {
            int n = this.endIndicator.get() - this.start.get();
            return n < 0 ? 0 : n;
        }

        void reset() {
            this.end.set(0);
            this.endIndicator.set(0);
            this.start.set(0);
        }
    }

    private static class Partition<E> {
        private final AtomicReference<StorageArray<E>> read;
        private volatile StorageArray<E> write;
        private final StorageArray<E> _1;
        private final StorageArray<E> _2;

        public Partition(int capacity) {
            this._1 = new StorageArray(capacity);
            this._2 = new StorageArray(capacity);
            this.read = new AtomicReference<StorageArray<E>>(this._1);
            this.write = this._2;
        }

        public boolean add(E e) {
            return this.add(e, 1);
        }

        private boolean add(E e, int retry) {
            StorageArray<E> write;
            if (retry > 10) {
                return false;
            }
            StorageArray<E> read = this.read.get();
            if (read == (write = this.write)) {
                return this.add(e, retry + 1);
            }
            return write.add(e);
        }

        public E poll() {
            return this.poll(1);
        }

        private E poll(int retry) {
            StorageArray<E> write;
            if (retry > 10) {
                return null;
            }
            StorageArray<E> read = this.read.get();
            if (read == (write = this.write)) {
                return this.poll(retry + 1);
            }
            E ret = read.poll();
            if (ret != null) {
                return ret;
            }
            int writeEnd = write.end.get();
            int writeEndIndicator = write.endIndicator.get();
            if (writeEnd < write.capacity) {
                return null;
            }
            if (writeEnd != writeEndIndicator) {
                return this.poll(retry + 1);
            }
            if (!this.read.compareAndSet(read, write)) {
                return this.poll(retry + 1);
            }
            assert (read.size() == 0);
            read.reset();
            this.write = read;
            return this.poll(retry + 1);
        }

        public int size() {
            return this._1.size() + this._2.size();
        }
    }
}

