/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.objectpool;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public class CursorList<E>
extends AbstractList<E>
implements RandomAccess {
    private Object[] elementData;
    private int size = 0;
    private int total = 0;
    private final ReusedIterator iterator = new ReusedIterator();

    public CursorList() {
        this(16);
    }

    public CursorList(int initialCapacity) {
        this.elementData = new Object[initialCapacity];
    }

    @Override
    public E get(int index) {
        return (E)this.elementData[index];
    }

    private void ensureCapacity(int cap) {
        if (this.elementData.length >= cap) {
            return;
        }
        Object[] arr = new Object[cap + 10];
        System.arraycopy(this.elementData, 0, arr, 0, this.elementData.length);
        this.elementData = arr;
    }

    @Override
    public boolean add(E element) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size] = element;
        ++this.size;
        if (this.size > this.total) {
            this.total = this.size;
        }
        return true;
    }

    public void store(E element) {
        this.ensureCapacity(this.total + 1);
        this.elementData[this.total] = element;
        ++this.total;
    }

    public void addAll(CursorList<E> ls) {
        this.ensureCapacity(this.size + ls.size);
        System.arraycopy(ls.elementData, 0, this.elementData, this.size, ls.size);
        this.size += ls.size;
        if (this.size > this.total) {
            this.total = this.size;
        }
    }

    @Override
    public E remove(int index) {
        if (index != this.size - 1) {
            throw new UnsupportedOperationException();
        }
        Object e = this.elementData[index];
        --this.size;
        return (E)e;
    }

    public E poll() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.size - 1);
    }

    @Override
    public int size() {
        return this.size;
    }

    public int total() {
        return this.total;
    }

    public int currentCapacity() {
        return this.elementData.length;
    }

    public void setSize(int size) {
        if (size > this.total) {
            throw new IndexOutOfBoundsException("size(" + size + ") > total(" + this.total + ")");
        }
        this.size = size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public Iterator<E> iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List that = (List)o;
        if (this.size != that.size()) {
            return false;
        }
        Iterator<E> iteThis = this.iterator();
        Iterator iteThat = that.iterator();
        while (iteThis.hasNext() && iteThat.hasNext()) {
            Object oThat;
            E oThis = iteThis.next();
            if (oThis == (oThat = iteThat.next())) continue;
            if (oThis == null || oThat == null) {
                return false;
            }
            if (oThis.equals(oThat)) continue;
            return false;
        }
        return true;
    }

    private class ReusedIterator
    implements Iterator<E> {
        private int cursor;

        private ReusedIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < CursorList.this.size;
        }

        @Override
        public E next() {
            return CursorList.this.elementData[this.cursor++];
        }

        void reset() {
            this.cursor = 0;
        }
    }
}

