/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.promise;

import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.callback.BlockCallback;
import io.vproxy.base.util.callback.Callback;
import io.vproxy.base.util.coll.Tuple;
import io.vproxy.base.util.promise.ThrowableFunction;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class Promise<T> {
    private volatile boolean done = false;
    private volatile T value;
    private volatile Throwable err;
    private volatile BiConsumer<T, Throwable> handler;

    public Promise(BiConsumer<Consumer<T>, Consumer<Throwable>> f) {
        f.accept(this::resolution, this::rejection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolution(T value) {
        Promise promise = this;
        synchronized (promise) {
            if (this.done) {
                Logger.error(LogType.IMPROPER_USE, "promise is already done but is calling resolution with " + value, new Throwable("stacktrace"));
                return;
            }
            this.done = true;
            this.value = value;
            if (this.handler == null) {
                return;
            }
        }
        this.handler.accept(value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rejection(Throwable err) {
        Objects.requireNonNull(err);
        Promise promise = this;
        synchronized (promise) {
            if (this.done) {
                Logger.error(LogType.IMPROPER_USE, "promise is already done but is calling rejection with " + err, new Throwable("stacktrace"));
                return;
            }
            this.done = true;
            this.err = err;
            if (this.handler == null) {
                return;
            }
        }
        this.handler.accept(null, err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHandler(BiConsumer<T, Throwable> handler) {
        Promise promise = this;
        synchronized (promise) {
            if (this.handler != null) {
                throw new IllegalStateException("handler is already set");
            }
            this.handler = handler;
            if (!this.done) {
                return;
            }
        }
        handler.accept(this.value, this.err);
    }

    public <U> Promise<U> then(ThrowableFunction<T, Promise<U>> thenFunc) {
        Objects.requireNonNull(thenFunc);
        Tuple<Promise<T>, Callback<T, Throwable>> tup = Promise.todo();
        Callback cb = (Callback)tup.right;
        this.setHandler((v, e) -> {
            if (e != null) {
                cb.failed(e);
            } else {
                Promise p;
                try {
                    p = (Promise)thenFunc.apply(v);
                }
                catch (Throwable ex) {
                    cb.failed(ex);
                    return;
                }
                p.setHandler((u, f) -> {
                    if (f != null) {
                        cb.failed(f);
                    } else {
                        cb.succeeded(u);
                    }
                });
            }
        });
        return (Promise)tup.left;
    }

    public Promise<T> exception(ThrowableFunction<Throwable, Promise<T>> catchFunc) {
        Objects.requireNonNull(catchFunc);
        Tuple<Promise<T>, Callback<T, Throwable>> tup = Promise.todo();
        Callback cb = (Callback)tup.right;
        this.setHandler((v, e) -> {
            if (e != null) {
                Promise p;
                try {
                    p = (Promise)catchFunc.apply((Throwable)e);
                }
                catch (Throwable ex) {
                    cb.failed(ex);
                    return;
                }
                p.setHandler((t, f) -> {
                    if (f != null) {
                        cb.failed(f);
                    } else {
                        cb.succeeded(t);
                    }
                });
            } else {
                cb.succeeded(v);
            }
        });
        return (Promise)tup.left;
    }

    public T block() throws Throwable {
        BlockCallback blockCB = new BlockCallback();
        this.setHandler((t, e) -> {
            if (e != null) {
                blockCB.failed(e);
            } else {
                blockCB.succeeded(t);
            }
        });
        return blockCB.block();
    }

    public static <T> Tuple<Promise<T>, Callback<T, Throwable>> todo() {
        Callback[] callbackPtr = new Callback[1];
        Promise<T> promise = new Promise<T>((resolutionFunc, rejectionFunc) -> {
            callbackPtr[0] = new Callback<T, Throwable>((Consumer)resolutionFunc, (Consumer)rejectionFunc){
                final /* synthetic */ Consumer val$resolutionFunc;
                final /* synthetic */ Consumer val$rejectionFunc;
                {
                    this.val$resolutionFunc = consumer;
                    this.val$rejectionFunc = consumer2;
                }

                @Override
                protected void onSucceeded(T value) {
                    this.val$resolutionFunc.accept(value);
                }

                @Override
                protected void onFailed(Throwable err) {
                    this.val$rejectionFunc.accept(err);
                }
            };
        });
        return new Tuple<Promise<T>, Callback<T, Throwable>>(promise, callbackPtr[0]);
    }

    public static <T, E extends Throwable> Promise<T> wrap(Consumer<Callback<T, E>> f) {
        return new Promise<T>((resolution, rejection) -> {
            Callback cb = new Callback<T, E>((Consumer)resolution, (Consumer)rejection){
                final /* synthetic */ Consumer val$resolution;
                final /* synthetic */ Consumer val$rejection;
                {
                    this.val$resolution = consumer;
                    this.val$rejection = consumer2;
                }

                @Override
                protected void onSucceeded(T value) {
                    this.val$resolution.accept(value);
                }

                @Override
                protected void onFailed(E err) {
                    this.val$rejection.accept(err);
                }
            };
            f.accept(cb);
        });
    }

    public static <T> Promise<T> resolve(T t) {
        return new Promise<T>((resolution, rejection) -> resolution.accept(t));
    }

    public static <T> Promise<T> reject(Throwable t) {
        return new Promise<T>((resolution, rejection) -> rejection.accept(t));
    }
}

