/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.ratelimit;

import io.vproxy.base.util.ratelimit.RateLimiter;

public class SimpleRateLimiter
extends RateLimiter {
    public final long capacity;
    public final long fillRate;
    private long tokens;
    private long lastTs;

    public SimpleRateLimiter(long capacity, long fillRate) {
        this.capacity = capacity;
        this.fillRate = fillRate;
        this.tokens = capacity;
        this.lastTs = System.currentTimeMillis();
    }

    @Override
    public boolean acquire(long n) {
        long delta;
        long tokens;
        if (this.capacity == -1L) {
            return true;
        }
        long currentTs = System.currentTimeMillis();
        if (currentTs < this.lastTs) {
            currentTs = this.lastTs;
        }
        if ((tokens = this.tokens + (delta = currentTs - this.lastTs) * this.fillRate) > this.capacity) {
            tokens = this.capacity;
        }
        if (tokens < n) {
            this.tokens = tokens;
            this.lastTs = currentTs;
            return false;
        }
        this.tokens = tokens -= n;
        this.lastTs = currentTs;
        return true;
    }
}

