/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.ratelimit;

import io.vproxy.base.util.coll.Tuple3;
import io.vproxy.base.util.ratelimit.RateLimiter;
import java.util.Arrays;

public class StatisticsRateLimiter
extends RateLimiter {
    private final RateLimiter rl;
    public final int recordingDuration;
    public final int samplingRate;
    private final long[] data;
    private int cursor = 0;
    private long lastTs;

    public StatisticsRateLimiter(RateLimiter rl, int recordingDuration, int samplingRate) {
        this.rl = rl;
        this.recordingDuration = recordingDuration;
        this.samplingRate = samplingRate;
        this.data = new long[recordingDuration / samplingRate];
        this.lastTs = this.formatTs(System.currentTimeMillis());
    }

    private long formatTs(long ts) {
        return ts - ts % (long)this.samplingRate;
    }

    public Tuple3<Long[], Long, Long> getStatistics(long beginTs, long endTs) {
        return this.getStatistics(beginTs, endTs, 1);
    }

    public Tuple3<Long[], Long, Long> getStatistics(long beginTs, long endTs, int step) {
        if (beginTs > endTs) {
            throw new IllegalArgumentException("beginTs " + beginTs + " > endTs " + endTs);
        }
        endTs = this.formatTs(endTs);
        beginTs = this.formatTs(beginTs);
        int beginDeltaIndexes = (int)((beginTs - this.lastTs) / (long)this.samplingRate);
        int endDeltaIndexes = (int)((endTs - this.lastTs) / (long)this.samplingRate);
        Long[] ret = new Long[endDeltaIndexes - beginDeltaIndexes + 1];
        int i = beginDeltaIndexes;
        int retIdx = 0;
        while (i <= endDeltaIndexes) {
            if (i <= 0 && (i >= 0 || -i < this.data.length)) {
                int idx = this.cursor + i;
                if (idx < 0) {
                    idx += this.data.length;
                }
                ret[retIdx] = this.data[idx];
            }
            ++i;
            ++retIdx;
        }
        if (step > 1) {
            Long[] foo = new Long[ret.length / step + (ret.length % step == 0 ? 0 : 1)];
            for (int i2 = 0; i2 < ret.length; i2 += step) {
                long value = 0L;
                boolean hasValue = false;
                for (int x = 0; x < step; ++x) {
                    if (ret.length <= i2 + x || ret[i2 + x] == null) continue;
                    value += ret[i2 + x].longValue();
                    hasValue = true;
                }
                foo[i2 / step] = hasValue ? Long.valueOf(value) : null;
            }
            ret = foo;
            endTs = (endTs - beginTs) / (long)step * (long)step + beginTs;
        }
        return new Tuple3<Long[], Long, Long>(ret, beginTs, endTs);
    }

    @Override
    public boolean acquire(long n) {
        int cursor;
        boolean ok = this.rl.acquire(n);
        if (!ok) {
            return false;
        }
        long current = System.currentTimeMillis();
        int delta = (int)(((current = this.formatTs(current)) - this.lastTs) / (long)this.samplingRate);
        if (delta < 0) {
            delta = 0;
        }
        if ((cursor = this.cursor + delta) >= this.data.length && cursor < this.data.length * 2) {
            int i;
            cursor -= this.data.length;
            for (i = this.cursor + 1; i < this.data.length; ++i) {
                this.data[i] = 0L;
            }
            for (i = 0; i < cursor; ++i) {
                this.data[i] = 0L;
            }
        } else if (cursor >= this.data.length * 2) {
            Arrays.fill(this.data, 0L);
            while (cursor >= this.data.length) {
                cursor -= this.data.length;
            }
        }
        if (delta != 0) {
            this.data[cursor] = 0L;
        }
        int n2 = cursor;
        this.data[n2] = this.data[n2] + n;
        this.cursor = cursor;
        this.lastTs = current;
        return true;
    }
}

