/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.ringbuffer;

import io.vproxy.base.util.RingBuffer;
import io.vproxy.base.util.RingBufferETHandler;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractRingBuffer
implements RingBuffer {
    private boolean operating = false;
    private final Set<RingBufferETHandler> handler = new HashSet<RingBufferETHandler>();
    private final Set<RingBufferETHandler> handlerToAdd = new HashSet<RingBufferETHandler>();
    private final Set<RingBufferETHandler> handlerToRemove = new HashSet<RingBufferETHandler>();

    protected boolean isOperating() {
        return this.operating;
    }

    protected void setOperating(boolean operating) {
        if (this.operating && !operating) {
            this.handler.removeAll(this.handlerToRemove);
            this.handler.addAll(this.handlerToAdd);
        }
        this.operating = operating;
    }

    protected void triggerReadable() {
        for (RingBufferETHandler aHandler : this.handler) {
            aHandler.readableET();
        }
    }

    protected void triggerWritable() {
        for (RingBufferETHandler aHandler : this.handler) {
            aHandler.writableET();
        }
    }

    @Override
    public void addHandler(RingBufferETHandler h) {
        if (this.operating) {
            this.handlerToRemove.remove(h);
            this.handlerToAdd.add(h);
        } else {
            this.handler.add(h);
        }
    }

    @Override
    public void removeHandler(RingBufferETHandler h) {
        if (this.operating) {
            this.handlerToAdd.remove(h);
            this.handlerToRemove.add(h);
        } else {
            this.handler.remove(h);
        }
    }

    @Override
    public Set<RingBufferETHandler> getHandlers() {
        return new HashSet<RingBufferETHandler>(this.handler);
    }
}

