/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.ringbuffer;

import io.vproxy.base.util.ByteBufferEx;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.RingBuffer;
import io.vproxy.base.util.RingBufferETHandler;
import io.vproxy.base.util.Utils;
import io.vproxy.base.util.coll.RingQueue;
import io.vproxy.base.util.ringbuffer.AbstractRingBuffer;
import io.vproxy.base.util.ringbuffer.ByteBufferRingBuffer;
import io.vproxy.base.util.ringbuffer.SimpleRingBuffer;
import io.vproxy.vfd.ReadableByteStream;
import io.vproxy.vfd.WritableByteStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AbstractUnwrapRingBuffer
extends AbstractRingBuffer {
    private static final int MAX_INTERMEDIATE_BUFFER_CAPACITY = 0x100000;
    ByteBufferRingBuffer plainBufferForApp;
    protected final SimpleRingBuffer encryptedBufferForInput;
    protected final WritableHandler writableHandler = new WritableHandler();
    private final RingQueue<ByteBufferRingBuffer> intermediateBuffers = new RingQueue();
    private ByteBuffer temporaryBuffer = null;
    private boolean triggerWritable = false;
    private IOException exceptionToThrow = null;

    public AbstractUnwrapRingBuffer(ByteBufferRingBuffer plainBufferForApp) {
        this.plainBufferForApp = plainBufferForApp;
        plainBufferForApp.addHandler(this.writableHandler);
        this.encryptedBufferForInput = RingBuffer.allocateDirect(plainBufferForApp.capacity());
    }

    private void checkException() throws IOException {
        if (this.exceptionToThrow != null) {
            throw this.exceptionToThrow;
        }
    }

    @Override
    public int storeBytesFrom(ReadableByteStream channel) throws IOException {
        int read;
        this.checkException();
        int len = 0;
        while ((read = this.encryptedBufferForInput.storeBytesFrom(channel)) != 0) {
            if (read == -1) {
                assert (Logger.lowLevelDebug("reading from remote return -1"));
                if (len != 0) break;
                return -1;
            }
            len += read;
            this.generalUnwrap();
        }
        return len;
    }

    protected ByteBufferRingBuffer getPlainBufferForApp() {
        return this.plainBufferForApp;
    }

    protected void recordIntermediateBuffer(ByteBuffer b) {
        this.intermediateBuffers.add(SimpleRingBuffer.wrap(b));
    }

    protected int intermediateBufferCap() {
        int cap = 0;
        for (ByteBufferRingBuffer buf : this.intermediateBuffers) {
            cap += buf.capacity();
        }
        return cap;
    }

    protected int intermediateBufferCount() {
        return this.intermediateBuffers.size();
    }

    protected ByteBuffer getTemporaryBuffer(int cap) {
        if (this.temporaryBuffer != null && this.temporaryBuffer.capacity() >= cap) {
            this.temporaryBuffer.limit(this.temporaryBuffer.capacity()).position(0);
            return this.temporaryBuffer;
        }
        this.temporaryBuffer = Utils.allocateByteBuffer(cap);
        return this.temporaryBuffer;
    }

    protected void discardTemporaryBuffer() {
        this.temporaryBuffer = null;
    }

    protected void generalUnwrap() {
        if (this.isOperating()) {
            assert (Logger.lowLevelDebug("generalUnwrap is operating"));
            return;
        }
        if (this.exceptionToThrow != null) {
            assert (Logger.lowLevelDebug("exit unwrap because of exception " + this.exceptionToThrow));
            return;
        }
        this.setOperating(true);
        try {
            this._generalUnwrap();
        }
        finally {
            if (this.triggerWritable) {
                this.triggerWritable = false;
                this.triggerWritable();
            }
            assert (Logger.lowLevelDebug("generalUnwrap is not operating now"));
            this.setOperating(false);
        }
    }

    private void _generalUnwrap() {
        while (!this.intermediateBuffers.isEmpty() && this.plainBufferForApp.free() != 0 || this.encryptedBufferForInput.used() != 0 && this.intermediateBufferCap() <= 0x100000) {
            while (!this.intermediateBuffers.isEmpty()) {
                ByteBufferRingBuffer buf = this.intermediateBuffers.peek();
                int wrote = 0;
                if (buf.used() != 0) {
                    wrote = buf.writeTo(this.plainBufferForApp, Integer.MAX_VALUE);
                }
                assert (Logger.lowLevelDebug("wrote " + wrote + " bytes to plain buffer"));
                if (buf.used() == 0) {
                    this.intermediateBuffers.poll();
                    this.triggerWritable = true;
                }
                if (this.plainBufferForApp.free() != 0) continue;
                break;
            }
            try {
                if (this.encryptedBufferForInput.used() == 0 || this.intermediateBufferCap() > 0x100000) continue;
                boolean canDefragment = this.encryptedBufferForInput.canDefragment();
                boolean[] underflow = new boolean[]{false};
                boolean[] errored = new boolean[]{false};
                IOException[] ex = new IOException[]{null};
                this.encryptedBufferForInput.operateOnByteBufferWriteOut(Integer.MAX_VALUE, encryptedBuffer -> this.handleEncryptedBuffer(encryptedBuffer, underflow, errored, ex));
                if (underflow[0]) {
                    if (canDefragment) {
                        this.encryptedBufferForInput.defragment();
                    } else {
                        assert (Logger.lowLevelDebug("got underflow, but the encrypted buffer cannot defragment, maybe buffer limit to small, or data not enough yet"));
                        errored[0] = true;
                    }
                }
                if (ex[0] != null) {
                    assert (Logger.lowLevelDebug("got exception from buffer" + ex[0]));
                    this.exceptionToThrow = ex[0];
                }
                if (!errored[0]) continue;
                return;
            }
            catch (IOException e) {
                Logger.shouldNotHappen("got exception when unwrapping", e);
                continue;
            }
            break;
        }
        return;
    }

    protected abstract void handleEncryptedBuffer(ByteBufferEx var1, boolean[] var2, boolean[] var3, IOException[] var4);

    @Override
    public int writeTo(WritableByteStream channel, int maxBytesToWrite) throws IOException {
        this.checkException();
        int bytes = 0;
        while (true) {
            int wrote = this.plainBufferForApp.writeTo(channel, maxBytesToWrite);
            if (this.plainBufferForApp.used() == 0) {
                this.generalUnwrap();
            }
            if (wrote == 0) break;
            bytes += wrote;
        }
        return bytes;
    }

    @Override
    public int free() {
        return this.encryptedBufferForInput.free();
    }

    @Override
    public int used() {
        return this.plainBufferForApp.used();
    }

    @Override
    public int capacity() {
        return this.plainBufferForApp.capacity();
    }

    @Override
    public void clean() {
        this.plainBufferForApp.clean();
        this.encryptedBufferForInput.clean();
    }

    @Override
    public void clear() {
        this.plainBufferForApp.clear();
    }

    @Override
    public RingBuffer switchBuffer(RingBuffer buf) throws RingBuffer.RejectSwitchException {
        if (this.plainBufferForApp.used() != 0) {
            throw new RingBuffer.RejectSwitchException("the plain buffer is not empty");
        }
        if (!(buf instanceof ByteBufferRingBuffer)) {
            throw new RingBuffer.RejectSwitchException("the input is not a ByteBufferRingBuffer");
        }
        if (buf.capacity() != this.plainBufferForApp.capacity()) {
            throw new RingBuffer.RejectSwitchException("capacity of new buffer is not the same as the old one");
        }
        this.plainBufferForApp.removeHandler(this.writableHandler);
        this.plainBufferForApp = (ByteBufferRingBuffer)buf;
        this.plainBufferForApp.addHandler(this.writableHandler);
        this.generalUnwrap();
        return this;
    }

    @Override
    public boolean isParentOf(RingBuffer buf) {
        return buf == this || buf == this.plainBufferForApp;
    }

    protected class WritableHandler
    implements RingBufferETHandler {
        protected WritableHandler() {
        }

        @Override
        public void readableET() {
            AbstractUnwrapRingBuffer.this.triggerReadable();
        }

        @Override
        public void writableET() {
            AbstractUnwrapRingBuffer.this.generalUnwrap();
        }
    }
}

