/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.ringbuffer;

import io.vproxy.base.util.ByteBufferEx;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.RingBuffer;
import io.vproxy.base.util.RingBufferETHandler;
import io.vproxy.base.util.Utils;
import io.vproxy.base.util.coll.RingQueue;
import io.vproxy.base.util.ringbuffer.AbstractRingBuffer;
import io.vproxy.base.util.ringbuffer.ByteBufferRingBuffer;
import io.vproxy.base.util.ringbuffer.SimpleRingBuffer;
import io.vproxy.vfd.ReadableByteStream;
import io.vproxy.vfd.WritableByteStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AbstractWrapRingBuffer
extends AbstractRingBuffer
implements RingBuffer {
    private static final int MAX_INTERMEDIATE_BUFFER_CAPACITY = 0x100000;
    private ByteBufferRingBuffer plainBufferForApp;
    private final SimpleRingBuffer encryptedBufferForOutput;
    private final ReadableHandler readableHandler = new ReadableHandler();
    private final RingQueue<ByteBufferRingBuffer> intermediateBuffers = new RingQueue();
    private ByteBuffer temporaryBuffer = null;
    private boolean triggerReadable = false;
    protected boolean transferring = false;
    private IOException exceptionToThrow = null;

    public AbstractWrapRingBuffer(ByteBufferRingBuffer plainBytesBuffer) {
        this.plainBufferForApp = plainBytesBuffer;
        this.encryptedBufferForOutput = RingBuffer.allocateDirect(plainBytesBuffer.capacity());
        this.plainBufferForApp.addHandler(this.readableHandler);
    }

    private void checkException() throws IOException {
        if (this.exceptionToThrow != null) {
            throw this.exceptionToThrow;
        }
    }

    protected ByteBufferRingBuffer getPlainBufferForApp() {
        return this.plainBufferForApp;
    }

    protected int getEncryptedBufferForOutputUsedSize() {
        return this.encryptedBufferForOutput.used();
    }

    protected int getEncryptedBufferForOutputCap() {
        return this.encryptedBufferForOutput.capacity();
    }

    protected void recordIntermediateBuffer(ByteBuffer b) {
        this.intermediateBuffers.add(SimpleRingBuffer.wrap(b));
    }

    protected int intermediateBufferCap() {
        int cap = 0;
        for (ByteBufferRingBuffer buf : this.intermediateBuffers) {
            cap += buf.capacity();
        }
        return cap;
    }

    protected int intermediateBufferCount() {
        return this.intermediateBuffers.size();
    }

    protected ByteBuffer getTemporaryBuffer(int cap) {
        if (this.temporaryBuffer != null && this.temporaryBuffer.capacity() >= cap) {
            this.temporaryBuffer.limit(this.temporaryBuffer.capacity()).position(0);
            return this.temporaryBuffer;
        }
        this.temporaryBuffer = Utils.allocateByteBuffer(cap);
        return this.temporaryBuffer;
    }

    protected void discardTemporaryBuffer() {
        this.temporaryBuffer = null;
    }

    void generalWrap() {
        if (this.isOperating()) {
            assert (Logger.lowLevelDebug("generalWrap is operating"));
            return;
        }
        do {
            assert (Logger.lowLevelDebug("begin to handle generalWrap"));
            if (this.exceptionToThrow != null) {
                assert (Logger.lowLevelDebug("exit wrap loop because of exception " + this.exceptionToThrow));
                return;
            }
            this.setOperating(true);
            try {
                this._generalWrap();
            }
            finally {
                if (this.triggerReadable) {
                    this.triggerReadable = false;
                    this.triggerReadable();
                }
                assert (Logger.lowLevelDebug("generalWrap is not operating now"));
                this.setOperating(false);
            }
        } while ((this.plainBufferForApp.used() != 0 || !this.intermediateBuffers.isEmpty()) && this.encryptedBufferForOutput.used() == 0 && this.transferring);
    }

    private void _generalWrap() {
        do {
            int intermediateBufferCap;
            assert (Logger.lowLevelDebug("calling _generalWrap"));
            while (!this.intermediateBuffers.isEmpty()) {
                ByteBufferRingBuffer buffer = this.intermediateBuffers.peek();
                int wrote = 0;
                if (buffer.used() != 0) {
                    wrote = buffer.writeTo(this.encryptedBufferForOutput, Integer.MAX_VALUE);
                }
                assert (Logger.lowLevelDebug("wrote " + wrote + " bytes encrypted data to the output buffer"));
                if (wrote > 0) {
                    this.triggerReadable = true;
                }
                if (buffer.used() == 0) {
                    this.intermediateBuffers.poll();
                }
                if (this.encryptedBufferForOutput.free() != 0) continue;
                break;
            }
            if ((intermediateBufferCap = this.intermediateBufferCap()) > 0x100000) {
                assert (Logger.lowLevelDebug("intermediateBufferCap = " + intermediateBufferCap + " > 1048576"));
                continue;
            }
            try {
                assert (Logger.lowLevelDebug("before handling data in plain buffer"));
                boolean[] errored = new boolean[]{false};
                IOException[] ex = new IOException[]{null};
                this.plainBufferForApp.operateOnByteBufferWriteOut(Integer.MAX_VALUE, bufferPlain -> this.handlePlainBuffer(bufferPlain, errored, ex));
                if (ex[0] != null) {
                    assert (Logger.lowLevelDebug("got exception from buffer" + ex[0]));
                    this.exceptionToThrow = ex[0];
                }
                if (errored[0]) {
                    assert (Logger.lowLevelDebug("handling data in plain buffer failed"));
                    return;
                }
            }
            catch (IOException e) {
                Logger.shouldNotHappen("got exception when wrapping", e);
            }
        } while (!this.intermediateBuffers.isEmpty() && this.encryptedBufferForOutput.free() != 0);
    }

    protected abstract void handlePlainBuffer(ByteBufferEx var1, boolean[] var2, IOException[] var3);

    @Override
    public int storeBytesFrom(ReadableByteStream channel) throws IOException {
        int read;
        this.checkException();
        int len = 0;
        while ((read = this.plainBufferForApp.storeBytesFrom(channel)) != 0) {
            if (read == -1) {
                if (len != 0) break;
                return -1;
            }
            len += read;
        }
        return len;
    }

    @Override
    public int writeTo(WritableByteStream channel, int maxBytesToWrite) throws IOException {
        this.checkException();
        int bytes = 0;
        while (true) {
            int wrote = this.encryptedBufferForOutput.writeTo(channel, maxBytesToWrite);
            this.generalWrap();
            if (wrote == 0 && (wrote = this.encryptedBufferForOutput.writeTo(channel, maxBytesToWrite)) == 0) break;
            bytes += wrote;
            maxBytesToWrite -= wrote;
        }
        return bytes;
    }

    @Override
    public int free() {
        return this.plainBufferForApp.free();
    }

    @Override
    public int used() {
        return this.encryptedBufferForOutput.used();
    }

    @Override
    public int capacity() {
        return this.plainBufferForApp.capacity();
    }

    @Override
    public void clean() {
        this.plainBufferForApp.clean();
        this.encryptedBufferForOutput.clean();
    }

    @Override
    public void clear() {
        this.plainBufferForApp.clear();
    }

    @Override
    public RingBuffer switchBuffer(RingBuffer buf) throws RingBuffer.RejectSwitchException {
        if (this.plainBufferForApp.used() != 0) {
            throw new RingBuffer.RejectSwitchException("the plain buffer is not empty");
        }
        if (!(buf instanceof ByteBufferRingBuffer)) {
            throw new RingBuffer.RejectSwitchException("the input is not a ByteBufferRingBuffer");
        }
        if (buf.capacity() != this.plainBufferForApp.capacity()) {
            throw new RingBuffer.RejectSwitchException("the new buffer capacity is not the same as the old one");
        }
        this.plainBufferForApp.removeHandler(this.readableHandler);
        this.plainBufferForApp = (ByteBufferRingBuffer)buf;
        this.plainBufferForApp.addHandler(this.readableHandler);
        this.generalWrap();
        return this;
    }

    @Override
    public boolean isParentOf(RingBuffer buf) {
        return buf == this || buf == this.plainBufferForApp;
    }

    class ReadableHandler
    implements RingBufferETHandler {
        ReadableHandler() {
        }

        @Override
        public void readableET() {
            AbstractWrapRingBuffer.this.generalWrap();
        }

        @Override
        public void writableET() {
            AbstractWrapRingBuffer.this.triggerWritable();
        }
    }
}

