/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.ringbuffer;

import io.vproxy.base.util.ByteBufferEx;
import io.vproxy.base.util.RingBuffer;
import java.io.IOException;

public interface ByteBufferRingBuffer
extends RingBuffer {
    public int operateOnByteBufferWriteOut(int var1, WriteOutOp var2) throws IOException;

    public int operateOnByteBufferStoreIn(StoreInOp var1) throws IOException;

    public boolean canDefragment();

    public void defragment();

    @Override
    default public int writeTo(RingBuffer buffer, int maxBytesToWrite) {
        if (!(buffer instanceof ByteBufferRingBuffer)) {
            return RingBuffer.super.writeTo(buffer, maxBytesToWrite);
        }
        ByteBufferRingBuffer targetBuffer = (ByteBufferRingBuffer)buffer;
        try {
            return this.operateOnByteBufferWriteOut(maxBytesToWrite, srcBuf -> targetBuffer.operateOnByteBufferStoreIn(tarBuf -> {
                int tarLen;
                int backupSrcBufLim = srcBuf.limit();
                int srcLen = backupSrcBufLim - srcBuf.position();
                if (srcLen > (tarLen = tarBuf.limit() - tarBuf.position())) {
                    srcBuf.limit(srcBuf.position() + tarLen);
                }
                tarBuf.put(srcBuf);
                srcBuf.limit(backupSrcBufLim);
                return true;
            }));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface StoreInOp {
        public boolean test(ByteBufferEx var1) throws IOException;
    }

    public static interface WriteOutOp {
        public void accept(ByteBufferEx var1) throws IOException;
    }
}

