/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.ringbuffer;

import io.vproxy.base.util.Logger;
import io.vproxy.base.util.RingBuffer;
import io.vproxy.base.util.RingBufferETHandler;
import io.vproxy.base.util.ringbuffer.AbstractRingBuffer;
import io.vproxy.base.util.ringbuffer.SimpleRingBuffer;
import io.vproxy.vfd.ReadableByteStream;
import io.vproxy.vfd.WritableByteStream;
import java.io.IOException;

public class ProxyOutputRingBuffer
extends AbstractRingBuffer {
    private final ProxiedETHandler proxiedETHandler = new ProxiedETHandler();
    private boolean isProxy = false;
    private final SimpleRingBuffer defaultBuffer;
    private final int cap;
    private RingBuffer proxied;
    private int proxyLen;
    private ProxyDoneCallback proxyDoneCallback;

    private ProxyOutputRingBuffer(SimpleRingBuffer defaultBuffer) {
        this.defaultBuffer = defaultBuffer;
        this.cap = defaultBuffer.capacity();
        defaultBuffer.addHandler(new DefaultBufferETHandler());
    }

    public static ProxyOutputRingBuffer allocateDirect(int cap) {
        return new ProxyOutputRingBuffer(SimpleRingBuffer.allocateDirect(cap));
    }

    public void proxy(RingBuffer proxied, int proxyLen, ProxyDoneCallback cb) {
        if (this.proxied != null) {
            throw new IllegalStateException("has a proxied buffer, with proxyLen = " + proxyLen);
        }
        assert (Logger.lowLevelDebug("get a buffer to proxy, data length is " + proxyLen));
        this.proxied = proxied;
        this.proxyLen = proxyLen;
        this.proxyDoneCallback = cb;
        this.proxied.addHandler(this.proxiedETHandler);
        if (this.defaultBuffer.used() == 0) {
            assert (Logger.lowLevelDebug("the defaultBuffer is empty now, switch to proxy mode"));
            this.isProxy = true;
            this.triggerReadable();
        } else assert (Logger.lowLevelDebug("still have data in the defaultBuffer"));
    }

    public void newDataFromProxiedBuffer() {
        if (this.proxied == null) {
            throw new IllegalStateException("no buffer to proxy but alarmed with 'new data from proxied buffer'");
        }
        if (this.isProxy) {
            this.triggerReadable();
        }
    }

    @Override
    public int storeBytesFrom(ReadableByteStream channel) throws IOException {
        if (this.proxied != null) {
            throw new IllegalStateException("has a proxied buffer, with proxyLen = " + this.proxyLen);
        }
        return this.defaultBuffer.storeBytesFrom(channel);
    }

    @Override
    public int writeTo(WritableByteStream channel, int maxBytesToWrite) throws IOException {
        if (this.isProxy) {
            int toWrite = Math.min(maxBytesToWrite, this.proxyLen);
            int wrote = this.proxied.writeTo(channel, toWrite);
            this.proxyLen -= wrote;
            if (this.proxyLen == 0) {
                this.isProxy = false;
                this.proxied.removeHandler(this.proxiedETHandler);
                this.proxied = null;
                ProxyDoneCallback cb = this.proxyDoneCallback;
                this.proxyDoneCallback = null;
                assert (Logger.lowLevelDebug("proxy end, calling proxy done callback"));
                cb.proxyDone();
            }
            return wrote;
        }
        int wrote = this.defaultBuffer.writeTo(channel, maxBytesToWrite);
        if (wrote == maxBytesToWrite) {
            return wrote;
        }
        if (this.proxied == null) {
            return wrote;
        }
        assert (Logger.lowLevelDebug("wrote all data from defaultBuffer, switch to proxy mode"));
        this.isProxy = true;
        return wrote + this.writeTo(channel, maxBytesToWrite - wrote);
    }

    @Override
    public int free() {
        return this.cap - this.used();
    }

    @Override
    public int used() {
        int proxyPart = 0;
        if (this.proxied != null) {
            int foo;
            int ret = this.cap;
            if (ret > this.proxyLen) {
                ret = this.proxyLen;
            }
            if (ret > (foo = this.proxied.used())) {
                ret = foo;
            }
            return ret;
        }
        if (this.isProxy) {
            return proxyPart;
        }
        return Math.min(this.cap, this.defaultBuffer.used() + proxyPart);
    }

    @Override
    public int capacity() {
        return this.cap;
    }

    @Override
    public void clean() {
        if (this.proxied != null) {
            this.proxied.removeHandler(this.proxiedETHandler);
            this.proxied = null;
            this.proxyLen = 0;
            this.proxyDoneCallback = null;
        }
        this.defaultBuffer.clean();
    }

    @Override
    public void clear() {
        this.defaultBuffer.clear();
    }

    public static interface ProxyDoneCallback {
        public void proxyDone();
    }

    private class ProxiedETHandler
    implements RingBufferETHandler {
        private ProxiedETHandler() {
        }

        @Override
        public void readableET() {
            if (ProxyOutputRingBuffer.this.isProxy) {
                ProxyOutputRingBuffer.this.triggerReadable();
            }
        }

        @Override
        public void writableET() {
        }
    }

    private class DefaultBufferETHandler
    implements RingBufferETHandler {
        private DefaultBufferETHandler() {
        }

        @Override
        public void readableET() {
            ProxyOutputRingBuffer.this.triggerReadable();
        }

        @Override
        public void writableET() {
        }
    }
}

