/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.ringbuffer;

import io.vproxy.base.util.ByteBufferEx;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.RingBuffer;
import io.vproxy.base.util.RingBufferETHandler;
import io.vproxy.base.util.Utils;
import io.vproxy.base.util.direct.DirectMemoryUtils;
import io.vproxy.base.util.nio.ByteArrayChannel;
import io.vproxy.base.util.ringbuffer.ByteBufferRingBuffer;
import io.vproxy.vfd.ReadableByteStream;
import io.vproxy.vfd.WritableByteStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;

public class SimpleRingBuffer
implements RingBuffer,
ByteBufferRingBuffer {
    private final boolean isDirect;
    private ByteBufferEx buffer;
    private int ePos;
    private int sPos;
    private final int cap;
    private boolean ePosIsAfterSPos = true;
    private boolean notFirstOperator = false;
    private boolean operating = false;
    private boolean operatingBuffer = false;
    private final Set<RingBufferETHandler> handler = new HashSet<RingBufferETHandler>();
    private final Set<RingBufferETHandler> handlerToAdd = new HashSet<RingBufferETHandler>();
    private final Set<RingBufferETHandler> handlerToRemove = new HashSet<RingBufferETHandler>();
    private boolean cleaned = false;

    public static SimpleRingBuffer allocateDirect(int cap) {
        return new SimpleRingBuffer(true, DirectMemoryUtils.allocateDirectBuffer(cap), 0, 0);
    }

    public static SimpleRingBuffer allocate(int cap) {
        return new SimpleRingBuffer(false, new ByteBufferEx(Utils.allocateByteBuffer(cap)), 0, 0);
    }

    public static SimpleRingBuffer wrap(ByteBuffer b) {
        return new SimpleRingBuffer(false, new ByteBufferEx(b), b.position(), b.limit());
    }

    private SimpleRingBuffer(boolean isDirect, ByteBufferEx buffer, int sPos, int ePos) {
        this.isDirect = isDirect;
        this.buffer = buffer;
        this.cap = buffer.capacity();
        this.sPos = sPos;
        this.ePos = ePos;
        if (this.ePos == this.cap) {
            this.ePos = 0;
            this.ePosIsAfterSPos = false;
        }
    }

    private int storeLimit() {
        if (this.ePosIsAfterSPos) {
            return this.cap - this.ePos;
        }
        return this.sPos - this.ePos;
    }

    private int retrieveLimit(int sPos, boolean ePosIsLimit) {
        if (ePosIsLimit) {
            return this.ePos - sPos;
        }
        return this.cap - sPos;
    }

    private int retrieveLimit() {
        return this.retrieveLimit(this.sPos, this.ePosIsAfterSPos);
    }

    @Override
    public int storeBytesFrom(ReadableByteStream channel) throws IOException {
        return this.operateOnByteBufferStoreIn(b -> channel.read(b.realBuffer()) != -1);
    }

    private void resetCursors() {
        assert (Logger.lowLevelNetDebug("reset cursors"));
        this.sPos = 0;
        this.ePos = 0;
        this.ePosIsAfterSPos = true;
    }

    @Override
    public int writeTo(WritableByteStream channel, int maxBytesToWrite) throws IOException {
        return this.operateOnByteBufferWriteOut(maxBytesToWrite, buffer -> channel.write(buffer.realBuffer()));
    }

    @Override
    public int free() {
        return this.cap - this.used();
    }

    @Override
    public int used() {
        if (this.ePosIsAfterSPos) {
            return this.ePos - this.sPos;
        }
        return this.ePos + this.cap - this.sPos;
    }

    @Override
    public int capacity() {
        return this.cap;
    }

    @Override
    public byte[] getBytes() {
        this.ensureBufferAvailable();
        int len = this.used();
        byte[] arr = Utils.allocateByteArray(len);
        if (len == 0) {
            return arr;
        }
        int lim = this.retrieveLimit();
        this.buffer.limit(this.sPos + lim).position(this.sPos);
        this.buffer.get(arr, 0, lim);
        if (this.ePosIsAfterSPos) {
            return arr;
        }
        int lim2 = this.retrieveLimit(0, true);
        if (lim2 == 0) {
            return arr;
        }
        this.buffer.limit(0 + lim2).position(0);
        this.buffer.get(arr, lim, lim2);
        return arr;
    }

    public String toString() {
        byte[] bytes = this.getBytes();
        return new String(bytes, 0, bytes.length, StandardCharsets.UTF_8);
    }

    @Override
    public void addHandler(RingBufferETHandler h) {
        if (this.operating) {
            this.handlerToRemove.remove(h);
            this.handlerToAdd.add(h);
        } else {
            this.handler.add(h);
        }
    }

    @Override
    public void removeHandler(RingBufferETHandler h) {
        if (this.operating) {
            this.handlerToAdd.remove(h);
            this.handlerToRemove.add(h);
        } else {
            this.handler.remove(h);
        }
    }

    @Override
    public Set<RingBufferETHandler> getHandlers() {
        return new HashSet<RingBufferETHandler>(this.handler);
    }

    @Override
    public void clean() {
        if (this.cleaned) {
            return;
        }
        this.cleaned = true;
        if (this.isDirect) {
            this.buffer.clean();
        }
    }

    private void ensureBufferAvailable() {
        if (this.cleaned) {
            throw new IllegalStateException("this buffer is already cleaned");
        }
    }

    @Override
    public void clear() {
        this.ensureBufferAvailable();
        byte[] b = Utils.allocateByteArray(this.capacity());
        ByteArrayChannel chnl = ByteArrayChannel.fromEmpty(b);
        while (this.used() != 0) {
            this.writeTo(chnl);
            chnl.reset();
        }
    }

    private boolean isFirstOperate() {
        boolean firstOperator;
        assert (Logger.lowLevelNetDebug("thread " + Thread.currentThread() + " is operating"));
        boolean bl = firstOperator = !this.notFirstOperator;
        if (firstOperator) {
            this.notFirstOperator = true;
        }
        this.operating = true;
        return firstOperator;
    }

    private void resetFirst(boolean firstOperator) {
        if (!firstOperator) {
            return;
        }
        this.operating = false;
        this.notFirstOperator = false;
        this.handler.removeAll(this.handlerToRemove);
        this.handler.addAll(this.handlerToAdd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int operateOnByteBufferWriteOut(int maxBytesToWrite, ByteBufferRingBuffer.WriteOutOp op) throws IOException {
        if (this.operatingBuffer) {
            throw new IllegalStateException("this buffer is operating");
        }
        this.ensureBufferAvailable();
        boolean firstOperator = this.isFirstOperate();
        this.operatingBuffer = true;
        boolean triggerWritable = false;
        assert (Logger.lowLevelNetDebug("before operate write out, sPos=" + this.sPos));
        try {
            boolean triggerWritablePre = this.free() == 0;
            int lim = this.retrieveLimit();
            int realWrite = Math.min(lim, maxBytesToWrite);
            int newLimit = this.sPos + realWrite;
            this.buffer.limit(newLimit).position(this.sPos);
            op.accept(this.buffer);
            if (newLimit != this.buffer.limit()) {
                assert (Logger.lowLevelDebug("newLimit=" + newLimit + ", buffer.limit()=" + this.buffer.limit()));
                throw new IllegalStateException("should only write out");
            }
            int write = this.buffer.position() - this.sPos;
            this.sPos += write;
            boolean bl = triggerWritable = triggerWritablePre && write > 0;
            if (this.sPos == this.cap) {
                this.sPos = 0;
                this.ePosIsAfterSPos = true;
            }
            if (write == lim && write <= maxBytesToWrite) {
                lim = this.retrieveLimit();
                if (lim == 0) {
                    this.resetCursors();
                    int n = write;
                    return n;
                }
                if (write == maxBytesToWrite) {
                    int n = write;
                    return n;
                }
                realWrite = Math.min(lim, maxBytesToWrite - write);
                newLimit = this.sPos + realWrite;
                this.buffer.limit(newLimit).position(this.sPos);
                op.accept(this.buffer);
                if (newLimit != this.buffer.limit()) {
                    assert (Logger.lowLevelDebug("newLimit=" + newLimit + ", buffer.limit()=" + this.buffer.limit()));
                    throw new IllegalStateException("should only write out");
                }
                int write2 = this.buffer.position() - this.sPos;
                this.sPos += write2;
                if (this.retrieveLimit() == 0) {
                    this.resetCursors();
                }
                int n = write + write2;
                return n;
            }
            int n = write;
            return n;
        }
        finally {
            assert (Logger.lowLevelNetDebug("after operate write out, sPos=" + this.sPos));
            this.operatingBuffer = false;
            if (triggerWritable) {
                assert (Logger.lowLevelNetDebug("trigger writable for " + this.handler.size() + " times"));
                for (RingBufferETHandler aHandler : this.handler) {
                    aHandler.writableET();
                }
            }
            this.resetFirst(firstOperator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int operateOnByteBufferStoreIn(ByteBufferRingBuffer.StoreInOp op) throws IOException {
        if (this.operatingBuffer) {
            throw new IllegalStateException("this buffer is operating");
        }
        this.ensureBufferAvailable();
        boolean firstOperator = this.isFirstOperate();
        this.operatingBuffer = true;
        boolean triggerReadable = false;
        assert (Logger.lowLevelNetDebug("before operate store in, ePos=" + this.ePos));
        try {
            boolean triggerReadablePre = this.used() == 0;
            int lim = this.storeLimit();
            if (lim == 0) {
                int n = 0;
                return n;
            }
            int newLimit = this.ePos + lim;
            this.buffer.limit(newLimit).position(this.ePos);
            boolean succeeded = op.test(this.buffer);
            if (newLimit != this.buffer.limit()) {
                assert (Logger.lowLevelDebug("newLimit=" + newLimit + ", buffer.limit()=" + this.buffer.limit()));
                throw new IllegalStateException("should only read in");
            }
            int read = this.buffer.position() - this.ePos;
            this.ePos += read;
            if (this.ePos == this.cap) {
                this.ePos = 0;
                this.ePosIsAfterSPos = false;
            }
            if (!succeeded) {
                int n = -1;
                return n;
            }
            boolean bl = triggerReadable = triggerReadablePre && read > 0;
            if (read == lim) {
                lim = this.storeLimit();
                if (lim == 0) {
                    int n = read;
                    return n;
                }
                newLimit = this.ePos + lim;
                this.buffer.limit(newLimit).position(this.ePos);
                succeeded = op.test(this.buffer);
                if (newLimit != this.buffer.limit()) {
                    assert (Logger.lowLevelDebug("newLimit=" + newLimit + ", buffer.limit()=" + this.buffer.limit()));
                    throw new IllegalStateException("should only read in");
                }
                int read2 = this.buffer.position() - this.ePos;
                this.ePos += read2;
                if (!succeeded) {
                    read2 = 0;
                }
                int n = read + read2;
                return n;
            }
            int n = read;
            return n;
        }
        finally {
            assert (Logger.lowLevelNetDebug("after operate store in, ePos=" + this.ePos));
            this.operatingBuffer = false;
            if (triggerReadable) {
                assert (Logger.lowLevelNetDebug("trigger readable for " + this.handler.size() + " times"));
                for (RingBufferETHandler aHandler : this.handler) {
                    aHandler.readableET();
                }
            }
            this.resetFirst(firstOperator);
        }
    }

    @Override
    public boolean canDefragment() {
        return this.sPos != 0;
    }

    @Override
    public void defragment() {
        if (this.operating) {
            throw new IllegalStateException("cannot perform defragment when it's operating");
        }
        this.ensureBufferAvailable();
        if (this.sPos == 0) {
            return;
        }
        ByteBufferEx newBuffer = this.isDirect ? DirectMemoryUtils.allocateDirectBuffer(this.cap) : new ByteBufferEx(Utils.allocateByteBuffer(this.cap));
        if (this.ePosIsAfterSPos) {
            this.buffer.limit(this.ePos).position(this.sPos);
        } else {
            this.buffer.limit(this.cap).position(this.sPos);
        }
        newBuffer.put(this.buffer);
        if (!this.ePosIsAfterSPos) {
            this.buffer.limit(this.ePos).position(0);
            newBuffer.put(this.buffer);
        }
        if (this.isDirect) {
            this.buffer.clean();
        }
        this.sPos = 0;
        this.ePos = newBuffer.position();
        this.ePosIsAfterSPos = true;
        if (this.ePos == this.cap) {
            this.ePos = 0;
            this.ePosIsAfterSPos = false;
        }
        this.buffer = newBuffer;
    }

    ByteBufferEx getBuffer() {
        return this.buffer;
    }

    int getSPos() {
        return this.sPos;
    }

    int getEPos() {
        return this.ePos;
    }

    boolean getEPosIsAfterSPos() {
        return this.ePosIsAfterSPos;
    }

    int getCap() {
        return this.cap;
    }
}

