/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.time.impl;

import io.vproxy.base.util.time.TimeElem;
import io.vproxy.base.util.time.TimeQueue;
import io.vproxy.base.util.time.impl.TimeElemImpl;
import java.util.PriorityQueue;

public class TimeQueueImpl<T>
implements TimeQueue<T> {
    final PriorityQueue<TimeElemImpl<T>> queue = new PriorityQueue((a, b) -> (int)(a.triggerTime - b.triggerTime));

    @Override
    public TimeElem<T> add(long currentTimestamp, int timeout, T elem) {
        TimeElemImpl<T> event = new TimeElemImpl<T>(currentTimestamp + (long)timeout, elem, this);
        this.queue.add(event);
        return event;
    }

    @Override
    public T poll() {
        TimeElemImpl<T> elem = this.queue.poll();
        if (elem == null) {
            return null;
        }
        return elem.elem;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int nextTime(long currentTimestamp) {
        TimeElemImpl<T> elem = this.queue.peek();
        if (elem == null) {
            return Integer.MAX_VALUE;
        }
        long triggerTime = elem.triggerTime;
        return Math.max((int)(triggerTime - currentTimestamp), 0);
    }
}

