/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util.web;

import java.util.HashMap;
import java.util.Map;

public class HttpStatusCodeReasonMap {
    private static final Map<Integer, String> map = new HashMap<Integer, String>(){
        {
            this.put(100, "Continue");
            this.put(101, "Switching Protocols");
            this.put(102, "Processing");
            this.put(103, "Early Hints");
            this.put(200, "OK");
            this.put(201, "Created");
            this.put(202, "Accepted");
            this.put(203, "Non-Authoritative Information");
            this.put(204, "No Content");
            this.put(205, "Reset Content");
            this.put(206, "Partial Content");
            this.put(207, "Multi-Status");
            this.put(208, "Already Reported");
            this.put(226, "IM Used");
            this.put(300, "Multiple Choices");
            this.put(301, "Moved Permanently");
            this.put(302, "Found");
            this.put(303, "See Other");
            this.put(304, "Not Modified");
            this.put(305, "Use Proxy");
            this.put(306, "Switch Proxy");
            this.put(307, "Temporary Redirect");
            this.put(308, "Permanent Redirect");
            this.put(400, "Bad Request");
            this.put(401, "Unauthorized");
            this.put(402, "Payment Required");
            this.put(403, "Forbidden");
            this.put(404, "Not Found");
            this.put(405, "Method Not Allowed");
            this.put(406, "Not Acceptable");
            this.put(407, "Proxy Authentication Required");
            this.put(408, "Request Timeout");
            this.put(409, "Conflict");
            this.put(410, "Gone");
            this.put(411, "Length Required");
            this.put(412, "Precondition Failed");
            this.put(413, "Payload Too Large");
            this.put(414, "URI Too Long");
            this.put(415, "Unsupported Media Type");
            this.put(416, "Range Not Satisfiable");
            this.put(417, "Expectation Failed");
            this.put(418, "I'm a teapot");
            this.put(421, "Misdirected Request");
            this.put(422, "Unprocessable Entity");
            this.put(423, "Locked");
            this.put(424, "Failed Dependency");
            this.put(425, "Too Early");
            this.put(426, "Upgrade Required");
            this.put(428, "Precondition Required");
            this.put(429, "Too Many Requests");
            this.put(431, "Request Header Fields Too Large");
            this.put(451, "Unavailable For Legal Reasons");
            this.put(500, "Internal Server Error");
            this.put(501, "Not Implemented");
            this.put(502, "Bad Gateway");
            this.put(503, "Service Unavailable");
            this.put(504, "Gateway Timeout");
            this.put(505, "HTTP Version Not Supported");
            this.put(506, "Variant Also Negotiates");
            this.put(507, "Insufficient Storage");
            this.put(508, "Loop Detected");
            this.put(510, "Not Extended");
            this.put(511, "Network Authentication Required");
        }
    };
    private static final Map<Integer, String> unknownMap = new HashMap<Integer, String>(){
        {
            this.put(1, "Informational Response");
            this.put(2, "Success");
            this.put(3, "Redirection");
            this.put(4, "Client Error");
            this.put(5, "Server Error");
        }
    };
    private static final String defaultReason = "Response";

    private HttpStatusCodeReasonMap() {
    }

    public static String get(int statusCode) {
        String ret = map.get(statusCode);
        if (ret != null) {
            return ret;
        }
        ret = unknownMap.get(statusCode / 100);
        if (ret != null) {
            return ret;
        }
        return defaultReason;
    }
}

