/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.commons.graph;

import io.vproxy.base.util.coll.Tuple;
import io.vproxy.commons.graph.GraphEdge;
import io.vproxy.commons.graph.GraphNode;
import io.vproxy.commons.graph.GraphPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Dijkstra {
    private Dijkstra() {
    }

    public static <N extends GraphNode<N>> Map<N, GraphPath<N>> dijkstra(N from) {
        return Dijkstra.dijkstra(from, Collections.emptySet());
    }

    public static <N extends GraphNode<N>> Map<N, GraphPath<N>> dijkstra(N from, Collection<N> skipNodes) {
        if (skipNodes.contains(from)) {
            throw new IllegalArgumentException("`skipNodes`=" + skipNodes + " contains `from`=" + from);
        }
        HashMap distances = new HashMap();
        distances.put(from, new Tuple(0L, new ArrayList()));
        HashSet<N> visited = new HashSet<N>();
        visited.add(from);
        Dijkstra.dijkstra(new HashSet<N>(skipNodes), visited, distances);
        HashMap res = new HashMap();
        for (Map.Entry entry : distances.entrySet()) {
            if (((List)((Tuple)entry.getValue())._2).isEmpty()) continue;
            res.put((GraphNode)entry.getKey(), new GraphPath((List)((Tuple)entry.getValue())._2));
        }
        return res;
    }

    private static <N extends GraphNode<N>> void dijkstra(Set<N> skipNodes, Set<N> visited, Map<N, Tuple<Long, List<GraphEdge<N>>>> distances) {
        for (GraphNode from : visited) {
            long len = (Long)distances.get((Object)from)._1;
            for (GraphEdge edge : from.allEdges()) {
                Object edgeTo = edge.to;
                if (skipNodes.contains(edgeTo)) continue;
                long totalLen = len + edge.distance;
                ArrayList ls = new ArrayList((Collection)distances.get((Object)from)._2);
                ls.add(edge);
                if (distances.containsKey(edgeTo) && (Long)distances.get(edgeTo)._1 <= totalLen) continue;
                distances.put(edgeTo, new Tuple(totalLen, ls));
            }
        }
        GraphNode nextNode = null;
        long nextLen = 0L;
        for (Map.Entry<N, Tuple<Long, List<GraphEdge<N>>>> entry : distances.entrySet()) {
            if (visited.contains(entry.getKey())) continue;
            Long l = (Long)entry.getValue()._1;
            if (nextNode == null) {
                nextNode = (GraphNode)entry.getKey();
                nextLen = l;
                continue;
            }
            if (nextLen <= l) continue;
            nextNode = (GraphNode)entry.getKey();
            nextLen = l;
        }
        if (nextNode == null) {
            return;
        }
        visited.add(nextNode);
        Dijkstra.dijkstra(skipNodes, visited, distances);
    }
}

