/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.commons.graph;

import io.vproxy.commons.graph.Dijkstra;
import io.vproxy.commons.graph.GraphNode;
import io.vproxy.commons.graph.GraphPath;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Graph<N extends GraphNode<N>> {
    private final Set<N> nodes;

    public Graph(Collection<N> nodes) {
        this.nodes = new HashSet<N>(nodes);
    }

    public Map<N, GraphPath<N>> shortestPaths(N from) {
        return this.shortestPaths(from, Collections.emptySet());
    }

    public Map<N, GraphPath<N>> shortestPaths(N from, Set<N> skipNodes) {
        if (!this.nodes.contains(from)) {
            throw new IllegalArgumentException("`from`=" + from + " is not contained in `nodes`");
        }
        return Dijkstra.dijkstra(from, skipNodes);
    }

    public boolean containsNode(N node) {
        return this.nodes.contains(node);
    }
}

