/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.commons.graph;

import io.vproxy.commons.graph.Graph;
import io.vproxy.commons.graph.GraphEdge;
import io.vproxy.commons.graph.GraphNode;
import java.util.HashMap;
import java.util.Map;

public class GraphBuilder<N extends GraphNode<N>> {
    protected final Map<String, N> nodes = new HashMap<String, N>();

    public GraphBuilder<N> addNode(N n) {
        if (this.nodes.containsKey(((GraphNode)n).name)) {
            throw new IllegalArgumentException("`node`=" + n + " is already registered");
        }
        if (this.nodes.containsValue(n)) {
            throw new IllegalArgumentException("`node`=" + n + " is already registered");
        }
        this.nodes.put(((GraphNode)n).name, n);
        return this;
    }

    public GraphBuilder<N> addTwoWayEdges(N a, N b, long distance) {
        this.addEdge(a, b, distance);
        this.addEdge(b, a, distance);
        return this;
    }

    public GraphBuilder<N> addEdge(String from, String to, long distance) {
        return this.addEdge((N)from, (N)to, null, distance);
    }

    public GraphBuilder<N> addEdge(String from, String to, String edgeName, long distance) {
        GraphNode fromN = (GraphNode)this.nodes.get(from);
        GraphNode toN = (GraphNode)this.nodes.get(to);
        if (fromN == null) {
            throw new IllegalArgumentException("node `from`=" + from + " does not exist");
        }
        if (toN == null) {
            throw new IllegalArgumentException("node `to`=" + to + " does not exist");
        }
        return this.addEdge(fromN, toN, edgeName, distance);
    }

    public GraphBuilder<N> addEdge(N from, N to, long distance) {
        return this.addEdge(from, to, null, distance);
    }

    public GraphBuilder<N> addEdge(N from, N to, String edgeName, long distance) {
        return this.addEdge(new GraphEdge<N>(edgeName, from, to, distance));
    }

    public GraphBuilder<N> addEdge(GraphEdge<N> edge) {
        if (edge.distance < 0L) {
            throw new IllegalArgumentException("`distance`=" + edge.distance + " < 0");
        }
        if (!this.nodes.containsValue(edge.from)) {
            throw new IllegalArgumentException("`from`=" + edge.from + " is not a registered node");
        }
        if (!this.nodes.containsValue(edge.to)) {
            throw new IllegalArgumentException("`to`=" + edge.to + " is not a registered node");
        }
        ((GraphNode)edge.from).register(edge);
        return this;
    }

    public Graph<N> build() {
        return new Graph<N>(this.nodes.values());
    }
}

