/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.commons.graph;

import io.vproxy.commons.graph.GraphNode;
import java.util.Objects;

public class GraphEdge<N extends GraphNode<N>> {
    public final String name;
    public final N from;
    public final N to;
    public final long distance;

    public GraphEdge(N from, N to, long distance) {
        this(null, from, to, distance);
    }

    public GraphEdge(String name, N from, N to, long distance) {
        this.name = name;
        this.from = from;
        this.to = to;
        this.distance = distance;
    }

    public String toString() {
        if (this.name != null) {
            return "{" + this.name + ":" + this.from + "---" + this.distance + "-->" + this.to + "}";
        }
        return "{" + this.from + "---" + this.distance + "-->" + this.to + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphEdge graphEdge = (GraphEdge)o;
        if (this.distance != graphEdge.distance) {
            return false;
        }
        if (!Objects.equals(this.from, graphEdge.from)) {
            return false;
        }
        return Objects.equals(this.to, graphEdge.to);
    }

    public int hashCode() {
        int result = this.from != null ? this.from.hashCode() : 0;
        result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
        result = 31 * result + (int)(this.distance ^ this.distance >>> 32);
        return result;
    }
}

