/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.commons.graph;

import io.vproxy.commons.graph.GraphEdge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphNode<N extends GraphNode<N>> {
    public final String name;
    private final Map<GraphNode<N>, Set<GraphEdge<N>>> edges = new HashMap<GraphNode<N>, Set<GraphEdge<N>>>();
    private final Map<String, List<GraphEdge<N>>> nameMap = new HashMap<String, List<GraphEdge<N>>>();
    private final Set<GraphEdge<N>> allEdges = new HashSet<GraphEdge<N>>();

    public GraphNode(String name) {
        this.name = name;
    }

    public boolean isLinkedToNextNode(GraphNode<N> node) {
        return this.edges.containsKey(node);
    }

    public void register(GraphEdge<N> edge) {
        Set<GraphEdge<N>> set = this.edges.get(edge.to);
        if (set == null) {
            set = new HashSet<GraphEdge<N>>();
            this.edges.put((GraphNode<N>)edge.to, set);
        }
        set.add(edge);
        this.allEdges.add(edge);
        if (edge.name != null) {
            List<GraphEdge<N>> ls = this.nameMap.get(edge.name);
            if (ls == null) {
                ls = new ArrayList<GraphEdge<N>>();
                this.nameMap.put(edge.name, ls);
            }
            ls.add(edge);
            ls.sort((a, b) -> (int)(a.distance - b.distance));
        }
    }

    public Collection<GraphEdge<N>> allEdges() {
        return this.allEdges;
    }

    public List<GraphEdge<N>> getEdges(String edgeName) {
        return this.nameMap.get(edgeName);
    }

    public String toString() {
        return "{" + this.name + "}";
    }
}

