/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.commons.graph;

import io.vproxy.commons.graph.GraphEdge;
import io.vproxy.commons.graph.GraphNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class GraphPath<N extends GraphNode<N>> {
    public final List<GraphEdge<N>> path;
    public final long length;
    public final N from;
    public final N to;

    public GraphPath(List<GraphEdge<N>> path) {
        this.path = Collections.unmodifiableList(path);
        long length = 0L;
        for (GraphEdge<N> p : path) {
            length += p.distance;
        }
        this.length = length;
        this.from = path.get((int)0).from;
        this.to = path.get((int)(path.size() - 1)).to;
    }

    public GraphPath<N> concat(GraphPath<N> path) {
        if (!this.path.get((int)(this.path.size() - 1)).to.equals(path.path.get((int)0).from)) {
            throw new IllegalArgumentException("cannot concat " + this + " and " + path);
        }
        ArrayList<GraphEdge<N>> ls = new ArrayList<GraphEdge<N>>();
        ls.addAll(this.path);
        ls.addAll(path.path);
        return new GraphPath<N>(ls);
    }

    public String toString() {
        return "GraphPath{" + this.path + ",len=" + this.length + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphPath graphPath = (GraphPath)o;
        return Objects.equals(this.path, graphPath.path);
    }

    public int hashCode() {
        return this.path != null ? this.path.hashCode() : 0;
    }
}

