/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.commons.util;

import io.vproxy.base.util.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class IOUtils {
    private IOUtils() {
    }

    public static void writeFileWithBackup(String filepath, String content) throws Exception {
        Logger.alert("Trying to write into file: " + filepath + ".new");
        File f = new File(filepath + ".new");
        if (f.exists()) {
            f.delete();
        } else {
            boolean ok;
            File parent = f.getParentFile();
            if (parent != null && !parent.exists() && !(ok = parent.mkdirs())) {
                throw new Exception("failed creating parent dir for " + f);
            }
        }
        if (!f.createNewFile()) {
            throw new Exception("Create new file " + filepath + ".new failed");
        }
        try (FileOutputStream fos = new FileOutputStream(f);){
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8));
            bw.write(content);
            bw.flush();
        }
        Logger.alert("Backup old file " + filepath);
        IOUtils.backupAndRemove(filepath);
        Logger.alert("Move new file to " + filepath);
        Files.move(Path.of(f.getAbsolutePath(), new String[0]), Path.of(filepath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        Logger.alert("Writing into file done: " + filepath);
    }

    private static void backupAndRemove(String filepath) throws Exception {
        File f = new File(filepath);
        File bakF = new File(filepath + ".bak");
        if (!f.exists()) {
            return;
        }
        if (bakF.exists() && !bakF.delete()) {
            throw new Exception("remove old backup file failed: " + bakF.getPath());
        }
        if (f.exists() && !f.renameTo(bakF)) {
            throw new Exception("backup the file failed: " + bakF.getPath());
        }
    }

    public static String writeTemporaryFile(String prefix, String suffix, byte[] content) throws IOException {
        return IOUtils.writeTemporaryFile(prefix, suffix, content, false);
    }

    public static String writeTemporaryFile(String prefix, String suffix, byte[] content, boolean executable) throws IOException {
        File f = File.createTempFile("vproxy-" + ProcessHandle.current().pid() + "-" + prefix, "." + suffix);
        f.deleteOnExit();
        Files.write(f.toPath(), content, new OpenOption[0]);
        f.setReadable(true);
        if (executable) {
            f.setExecutable(true);
        }
        return f.getAbsolutePath();
    }

    public static boolean deleteDirectory(File base) {
        if (base.isFile()) {
            return base.delete();
        }
        if (!base.isDirectory()) {
            return true;
        }
        File[] allContents = base.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                boolean ok = IOUtils.deleteDirectory(file);
                if (ok) continue;
                return false;
            }
        }
        return base.delete();
    }

    public static void copyDirectory(Path src, Path dest) throws IOException {
        IOUtils.copyDirectory(src, dest, null);
    }

    public static void copyDirectory(Path src, Path dest, Predicate<Path> skipFile) throws IOException {
        try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
            Iterator ite = stream.iterator();
            while (ite.hasNext()) {
                Path source = (Path)ite.next();
                IOUtils._copyDirectory(source, dest.resolve(src.relativize(source)), skipFile);
            }
        }
    }

    private static void _copyDirectory(Path source, Path dest, Predicate<Path> skipFile) throws IOException {
        if (source.toFile().isDirectory() && dest.toFile().isDirectory()) {
            return;
        }
        if (skipFile != null && skipFile.test(source)) {
            return;
        }
        Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
    }
}

