/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfd;

import io.vproxy.base.dns.DnsServerListGetter;
import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.IPType;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.ToByteArray;
import io.vproxy.base.util.Utils;
import io.vproxy.base.util.callback.BlockCallback;
import io.vproxy.vfd.IPPort;
import io.vproxy.vfd.IPv4;
import io.vproxy.vfd.IPv6;
import io.vproxy.vpacket.dns.DNSClass;
import io.vproxy.vpacket.dns.DNSPacket;
import io.vproxy.vpacket.dns.DNSQuestion;
import io.vproxy.vpacket.dns.DNSResource;
import io.vproxy.vpacket.dns.DNSType;
import io.vproxy.vpacket.dns.Formatter;
import io.vproxy.vpacket.dns.InvalidDNSPacketException;
import io.vproxy.vpacket.dns.rdata.A;
import io.vproxy.vpacket.dns.rdata.AAAA;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public abstract class IP
implements ToByteArray {
    public final String hostname;
    public final ByteArray bytes;

    public static IP from(String hostname, IP ip) {
        return IP.from(hostname, ip.getAddress());
    }

    public static IP from(InetAddress ip) {
        return IP.from(null, ip);
    }

    public static IP from(String hostname, InetAddress ip) {
        return IP.from(hostname, ip.getAddress());
    }

    public static IP from(byte[] arr) {
        return IP.from(null, arr);
    }

    public static IP from(String hostname, byte[] arr) {
        if (arr.length == 4) {
            return new IPv4(hostname, arr);
        }
        if (arr.length == 16) {
            return new IPv6(hostname, arr);
        }
        throw new IllegalArgumentException("unknown ip address");
    }

    public static IP from(String ip) {
        return IP.from(null, ip);
    }

    public static IP from(String hostname, String ip) {
        byte[] bytes = IP.parseIpString(ip);
        if (bytes == null) {
            throw new IllegalArgumentException("input is not a valid ip string");
        }
        return IP.from(hostname, bytes);
    }

    public static IPv4 fromIPv4(byte[] bytes) {
        return IP.fromIPv4(null, bytes);
    }

    public static IPv4 fromIPv4(String hostname, byte[] bytes) {
        if (bytes.length != 4) {
            throw new IllegalArgumentException("input is not a valid ipv4 address");
        }
        return new IPv4(hostname, bytes);
    }

    public static IPv4 fromIPv4(String ip) {
        return IP.fromIPv4(null, ip);
    }

    public static IPv4 fromIPv4(String hostname, String ip) {
        byte[] bytes = IP.parseIpv4String(ip);
        if (bytes == null) {
            throw new IllegalArgumentException("input is not a valid ipv4 string");
        }
        return IP.fromIPv4(hostname, bytes);
    }

    public static IPv6 fromIPv6(byte[] bytes) {
        return IP.fromIPv6(null, bytes);
    }

    public static IPv6 fromIPv6(String hostname, byte[] bytes) {
        if (bytes.length != 16) {
            throw new IllegalArgumentException("input is not a valid ipv6 address");
        }
        return new IPv6(hostname, bytes);
    }

    public static IPv6 fromIPv6(String ip) {
        return IP.fromIPv6(null, ip);
    }

    public static IPv6 fromIPv6(String hostname, String ip) {
        byte[] bytes = IP.parseIpv6String(ip);
        if (bytes == null) {
            throw new IllegalArgumentException("input is not a valid ipv6 string");
        }
        return IP.fromIPv6(hostname, bytes);
    }

    public static IP fromMask(boolean isIPv6, int prefixLength) {
        if (prefixLength < 0 || prefixLength > 128) {
            throw new IllegalArgumentException("mask " + prefixLength + " out of range");
        }
        if (!isIPv6 && prefixLength > 32) {
            throw new IllegalArgumentException("mask " + prefixLength + " cannot be applied to ipv4");
        }
        byte[] res = isIPv6 ? new byte[16] : new byte[4];
        for (int i = 0; i < res.length; ++i) {
            if (prefixLength >= 8) {
                res[i] = -1;
                prefixLength -= 8;
                continue;
            }
            if (prefixLength == 0) {
                res[i] = 0;
                continue;
            }
            res[i] = (byte)(255 << 8 - prefixLength & 0xFF);
            prefixLength = 0;
        }
        return IP.from(res);
    }

    IP(String hostname, ByteArray bytes) {
        this.hostname = hostname;
        this.bytes = bytes.unmodifiable();
    }

    @Override
    public ByteArray toByteArray() {
        return this.bytes;
    }

    public boolean isAnyLocalAddress() {
        for (int i = 0; i < this.bytes.length(); ++i) {
            byte b = this.bytes.get(i);
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isLinkLocalAddress() {
        if (this instanceof IPv6) {
            return this.bytes.get(0) == -2 && (this.bytes.get(1) & 0xC0) == 128;
        }
        return false;
    }

    public String getHostName() {
        return this.hostname;
    }

    public byte[] getAddress() {
        return this.bytes.toJavaArray();
    }

    public InetAddress toInetAddress() {
        return IP.l3addr(this.getAddress());
    }

    public String formatToIPString() {
        return IP.ipStr(this.bytes.toJavaArray());
    }

    public abstract IPv4 to4();

    public abstract IPv6 to6();

    public abstract IP stripHostname();

    public String toString() {
        return (this.hostname == null ? "" : this.hostname) + "/" + this.formatToIPString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof IP)) {
            return false;
        }
        IP that = (IP)o;
        if (!this.ipEquals(o)) {
            return false;
        }
        return Objects.equals(this.hostname, that.hostname);
    }

    public abstract boolean ipEquals(Object var1);

    public abstract int hashCode();

    public static byte[] parseIpString(String ip) {
        if (ip.contains(":")) {
            return IP.parseIpv6String(ip);
        }
        return IP.parseIpv4String(ip);
    }

    public static byte[] parseIpv4String(String ipv4) {
        byte[] ipBytes = Utils.allocateByteArrayInitZero(4);
        if (IP.parseIpv4String(ipv4, ipBytes, 0) == -1) {
            return null;
        }
        return ipBytes;
    }

    private static int parseIpv4String(String ipv4, byte[] ipBytes, int fromIdx) {
        String[] split = Utils.split(ipv4, ".");
        if (split.length != 4) {
            return -1;
        }
        for (int i = 0; i < split.length; ++i) {
            int idx = fromIdx + i;
            if (idx >= ipBytes.length) {
                return -1;
            }
            String s = split[i];
            char[] digits = s.toCharArray();
            if (digits.length > 3 || digits.length == 0) {
                return -1;
            }
            for (char c : digits) {
                if (c >= '0' && c <= '9') continue;
                return -1;
            }
            if (s.startsWith("0") && s.length() > 1) {
                return -1;
            }
            int num = Integer.parseInt(s);
            if (num > 255) {
                return -1;
            }
            ipBytes[idx] = (byte)num;
        }
        return split.length;
    }

    public static byte[] parseIpv6String(String ipv6) {
        String colonAndDot;
        String colonOnly;
        boolean hasDblColon;
        int count;
        if (ipv6.startsWith("[") && ipv6.endsWith("]")) {
            ipv6 = ipv6.substring(1, ipv6.length() - 1);
        }
        if ((count = Utils.split(ipv6, "::").length - 1) > 1) {
            return null;
        }
        int idx = ipv6.indexOf("::");
        if (idx == -1) {
            hasDblColon = false;
            colonOnly = null;
            colonAndDot = ipv6;
        } else {
            hasDblColon = true;
            colonOnly = ipv6.substring(0, idx);
            colonAndDot = ipv6.substring(idx + "::".length());
        }
        byte[] ipBytes = Utils.allocateByteArrayInitZero(16);
        int consumed = IP.parseIpv6ColonPart(colonOnly, ipBytes, 0);
        if (consumed == -1) {
            return null;
        }
        int consumed2 = IP.parseIpv6LastBits(colonAndDot, ipBytes);
        if (consumed2 == -1) {
            return null;
        }
        if (hasDblColon ? consumed + consumed2 >= 16 : consumed + consumed2 != 16) {
            return null;
        }
        return ipBytes;
    }

    private static int parseIpv6ColonPart(String s, byte[] ipBytes, int fromIdx) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        if (fromIdx < 0) {
            return -1;
        }
        String[] split = Utils.split(s, ":");
        block6: for (int i = 0; i < split.length; ++i) {
            int baseIndex = fromIdx + 2 * i;
            if (baseIndex >= ipBytes.length) {
                return -1;
            }
            char[] field = split[i].toCharArray();
            if (field.length > 4) {
                return -1;
            }
            if (field.length == 0) {
                return -1;
            }
            for (char c : field) {
                if (c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f' || c >= '0' && c <= '9') continue;
                return -1;
            }
            switch (field.length) {
                case 1: {
                    ipBytes[baseIndex + 1] = (byte)Integer.parseInt("" + field[0], 16);
                    continue block6;
                }
                case 2: {
                    ipBytes[baseIndex + 1] = (byte)Integer.parseInt("" + field[0] + field[1], 16);
                    continue block6;
                }
                case 3: {
                    ipBytes[baseIndex] = (byte)Integer.parseInt("" + field[0], 16);
                    ipBytes[baseIndex + 1] = (byte)Integer.parseInt("" + field[1] + field[2], 16);
                    continue block6;
                }
                case 4: {
                    ipBytes[baseIndex] = (byte)Integer.parseInt("" + field[0] + field[1], 16);
                    ipBytes[baseIndex + 1] = (byte)Integer.parseInt("" + field[2] + field[3], 16);
                    continue block6;
                }
                default: {
                    return -1;
                }
            }
        }
        return split.length * 2;
    }

    private static int parseIpv6LastBits(String s, byte[] ipBytes) {
        if (s.contains(".")) {
            int idx = s.indexOf(46);
            if ((idx = s.lastIndexOf(58, idx)) == -1) {
                return IP.parseIpv4String(s, ipBytes, ipBytes.length - 4);
            }
            String colonPart = s.substring(0, idx);
            String dotPart = s.substring(idx + 1);
            int r = IP.parseIpv4String(dotPart, ipBytes, ipBytes.length - 4);
            if (r == -1) {
                return -1;
            }
            return 4 + IP.parseIpv6ColonPart(colonPart, ipBytes, ipBytes.length - 4 - Utils.split(colonPart, ":").length * 2);
        }
        return IP.parseIpv6ColonPart(s, ipBytes, ipBytes.length - Utils.split(s, ":").length * 2);
    }

    public static byte[] parseIpv4StringConsiderV6Compatible(String s) {
        byte[] v6 = IP.parseIpv6String(s);
        if (v6 != null) {
            int i;
            for (i = 0; i < 10; ++i) {
                if (0 == v6[i]) continue;
                return null;
            }
            for (i = 11; i < 12; ++i) {
                if (-1 == v6[i]) continue;
                return null;
            }
            byte[] v4 = Utils.allocateByteArrayInitZero(4);
            System.arraycopy(v6, 12, v4, 0, 4);
            return v4;
        }
        return IP.parseIpv4String(s);
    }

    public static boolean isIpv4(String s) {
        return IP.parseIpv4StringConsiderV6Compatible(s) != null;
    }

    public static boolean isIpv6(String s) {
        return IP.parseIpv6String(s) != null;
    }

    public static boolean isIpLiteral(String s) {
        return IP.isIpv4(s) || IP.isIpv6(s);
    }

    public static IPPort blockParseL4Addr(String l4addr) throws IllegalArgumentException {
        int port;
        if (!l4addr.contains(":")) {
            throw new IllegalArgumentException("missing port");
        }
        String ip = l4addr.substring(0, l4addr.lastIndexOf(":"));
        String portStr = l4addr.substring(l4addr.lastIndexOf(":") + 1);
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid port number");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("invalid port number: out of range");
        }
        return new IPPort(IP.blockResolve(ip), port);
    }

    public static IP getInetAddressFromNic(String nicName, IPType ipType) throws SocketException {
        Inet4Address bindInetAddress;
        Inet4Address v4Addr = null;
        InetAddress v6Addr = null;
        Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
        block0: while (nics.hasMoreElements()) {
            NetworkInterface nic = nics.nextElement();
            if (!nicName.equals(nic.getDisplayName())) continue;
            Enumeration<InetAddress> addresses = nic.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress a = addresses.nextElement();
                if (a instanceof Inet4Address) {
                    v4Addr = (Inet4Address)a;
                } else if (a instanceof Inet6Address) {
                    v6Addr = (Inet6Address)a;
                }
                if (v4Addr == null || v6Addr == null) continue;
                break block0;
            }
            break block0;
        }
        if (v4Addr == null && v6Addr == null) {
            throw new SocketException("nic " + nicName + " not found or no ip address");
        }
        if (ipType == IPType.v4 && v4Addr == null) {
            throw new SocketException("nic " + nicName + " do not have a v4 ip");
        }
        if (ipType == IPType.v6 && v6Addr == null) {
            throw new SocketException("nic " + nicName + " do not have a v6 ip");
        }
        if (ipType == IPType.v4) {
            assert (v4Addr != null);
            bindInetAddress = v4Addr;
        } else {
            assert (v6Addr != null);
            bindInetAddress = v6Addr;
        }
        return IP.from(bindInetAddress);
    }

    private static InetAddress l3addr(byte[] addr) {
        try {
            return InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            StringBuilder err = new StringBuilder("creating l3addr from ");
            boolean isFirst = true;
            for (byte x : addr) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    err.append(".");
                }
                err.append(x & 0xFF);
            }
            err.append(" failed");
            Logger.shouldNotHappen(err.toString(), e);
            throw new RuntimeException(e);
        }
    }

    public static String ipStr(byte[] ip) {
        if (ip.length == 16) {
            return IP.ipv6Str(ip);
        }
        if (ip.length == 4) {
            return IP.ipv4Str(ip);
        }
        throw new IllegalArgumentException("unknown ip " + Arrays.toString(ip));
    }

    public static String ipv6Str(byte[] ip) {
        String[] split = new String[]{Integer.toHexString((ip[0] & 0xFF) << 8 & 0xFFFF | ip[1] & 0xFF), Integer.toHexString((ip[2] & 0xFF) << 8 & 0xFFFF | ip[3] & 0xFF), Integer.toHexString((ip[4] & 0xFF) << 8 & 0xFFFF | ip[5] & 0xFF), Integer.toHexString((ip[6] & 0xFF) << 8 & 0xFFFF | ip[7] & 0xFF), Integer.toHexString((ip[8] & 0xFF) << 8 & 0xFFFF | ip[9] & 0xFF), Integer.toHexString((ip[10] & 0xFF) << 8 & 0xFFFF | ip[11] & 0xFF), Integer.toHexString((ip[12] & 0xFF) << 8 & 0xFFFF | ip[13] & 0xFF), Integer.toHexString((ip[14] & 0xFF) << 8 & 0xFFFF | ip[15] & 0xFF)};
        int max = 0;
        int idx = split.length;
        int endExclusive = 0;
        int curLen = 0;
        int curIdx = -1;
        for (int i = 0; i <= split.length; ++i) {
            String s = i < split.length ? split[i] : "";
            if (s.equals("0")) {
                if (curIdx == -1) {
                    curIdx = i;
                }
                ++curLen;
                continue;
            }
            if (curIdx == -1) continue;
            if (max < curLen) {
                max = curLen;
                idx = curIdx;
                endExclusive = i;
            }
            curLen = 0;
            curIdx = -1;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < split.length; ++i) {
            if (i < idx || i >= endExclusive) {
                if (i != 0 && i != endExclusive) {
                    sb.append(":");
                }
                sb.append(split[i]);
                continue;
            }
            if (i != idx) continue;
            sb.append("::");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String ipv4Str(byte[] ip) {
        return Utils.positive(ip[0]) + "." + Utils.positive(ip[1]) + "." + Utils.positive(ip[2]) + "." + Utils.positive(ip[3]);
    }

    public static IP blockResolve(String hostOrIp) throws IllegalArgumentException {
        List<IP> res = IP.blockResolve(hostOrIp, DNSType.A);
        if (res.isEmpty() && (res = IP.blockResolve(hostOrIp, DNSType.AAAA)).isEmpty()) {
            throw new IllegalArgumentException("no ip available for " + hostOrIp);
        }
        return res.get(0);
    }

    public static List<IP> blockResolve(String address, DNSType dnsType) throws IllegalArgumentException {
        return IP.blockResolve(address, dnsType, null);
    }

    public static List<IP> blockResolve(String host, DNSType dnsType, List<IPPort> dnsServerList) throws IllegalArgumentException {
        if (IP.isIpLiteral(host)) {
            return List.of(IP.from(host));
        }
        if (dnsServerList == null || dnsServerList.isEmpty()) {
            List<DnsServerListGetter> getters = DnsServerListGetter.allGettersNoDefault();
            for (DnsServerListGetter getter : getters) {
                BlockCallback<List<IPPort>, Throwable> cb = new BlockCallback<List<IPPort>, Throwable>();
                getter.get(cb);
                try {
                    dnsServerList = cb.block();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (dnsServerList == null || dnsServerList.isEmpty()) continue;
                break;
            }
        }
        if (dnsServerList == null || dnsServerList.isEmpty()) {
            assert (Logger.lowLevelDebug("no dns server available"));
            try {
                InetAddress inet = InetAddress.getByName(host);
                return List.of(IP.from(host, inet));
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
        }
        byte[] rcvBuf = new byte[1600];
        ArrayList<IP> ret = new ArrayList<IP>();
        for (IPPort ipport : dnsServerList) {
            try (DatagramSocket sock = new DatagramSocket();){
                sock.setSoTimeout(2000);
                sock.connect(ipport.toInetSocketAddress());
                int id = ThreadLocalRandom.current().nextInt(1000);
                DNSPacket dnsPacket = new DNSPacket();
                dnsPacket.id = id;
                dnsPacket.opcode = DNSPacket.Opcode.QUERY;
                dnsPacket.rd = true;
                dnsPacket.rcode = DNSPacket.RCode.NoError;
                dnsPacket.questions = new ArrayList<DNSQuestion>();
                DNSQuestion q = new DNSQuestion();
                dnsPacket.questions.add(q);
                q.qname = host;
                q.qtype = dnsType;
                q.qclass = DNSClass.IN;
                byte[] bytes = dnsPacket.toByteArray().toJavaArray();
                DatagramPacket d = new DatagramPacket(bytes, bytes.length);
                sock.send(d);
                d = new DatagramPacket(rcvBuf, rcvBuf.length);
                sock.receive(d);
                List<DNSPacket> packets = Formatter.parsePackets(ByteArray.from(d.getData()).sub(d.getOffset(), d.getLength()));
                for (DNSPacket p : packets) {
                    if (!p.isResponse) {
                        assert (Logger.lowLevelDebug("is not response"));
                        continue;
                    }
                    if (p.id != id) {
                        assert (Logger.lowLevelDebug("id mismatch"));
                        continue;
                    }
                    if (p.answers == null) {
                        assert (Logger.lowLevelDebug("no answers section"));
                        continue;
                    }
                    for (DNSResource ans : p.answers) {
                        if (ans.rdata == null) {
                            assert (Logger.lowLevelDebug("rdata is null"));
                            continue;
                        }
                        if (ans.rdata instanceof A) {
                            A a = (A)ans.rdata;
                            ret.add(IP.from(host, a.address));
                            continue;
                        }
                        if (ans.rdata instanceof AAAA) {
                            AAAA aaaa = (AAAA)ans.rdata;
                            ret.add(IP.from(host, aaaa.address));
                            continue;
                        }
                        assert (Logger.lowLevelDebug("rdata not A nor AAAA"));
                    }
                }
                break;
            }
            catch (InvalidDNSPacketException | IOException e) {
                assert (Logger.lowLevelDebug("failed to run dns resolve for " + host + ": " + e));
            }
        }
        return ret;
    }

    public static int ipv4Bytes2Int(byte[] host) {
        return (host[0] & 0xFF) << 24 | (host[1] & 0xFF) << 16 | (host[2] & 0xFF) << 8 | host[3] & 0xFF;
    }

    public static byte[] ipv4Int2Bytes(int ip) {
        byte[] ret = Utils.allocateByteArrayInitZero(4);
        ret[0] = (byte)(ip >> 24 & 0xFF);
        ret[1] = (byte)(ip >> 16 & 0xFF);
        ret[2] = (byte)(ip >> 8 & 0xFF);
        ret[3] = (byte)(ip & 0xFF);
        return ret;
    }

    public boolean isMask() {
        return this.toPrefixLength() != -1;
    }

    public int toPrefixLength() {
        int res = 0;
        boolean mustBeZero = false;
        block10: for (int i = 0; i < this.bytes.length(); ++i) {
            byte b = this.bytes.get(i);
            if (mustBeZero) {
                if (b == 0) continue;
                return -1;
            }
            if (b == -1) {
                res += 8;
                continue;
            }
            mustBeZero = true;
            switch (b) {
                case -2: {
                    res += 7;
                    continue block10;
                }
                case -4: {
                    res += 6;
                    continue block10;
                }
                case -8: {
                    res += 5;
                    continue block10;
                }
                case -16: {
                    res += 4;
                    continue block10;
                }
                case -32: {
                    res += 3;
                    continue block10;
                }
                case -64: {
                    res += 2;
                    continue block10;
                }
                case -128: {
                    ++res;
                    continue block10;
                }
                case 0: {
                    continue block10;
                }
                default: {
                    return -1;
                }
            }
        }
        return res;
    }

    public abstract boolean isBroadcast();

    public abstract boolean isMulticast();

    public boolean isUnicast() {
        return !this.isMulticast() && !this.isBroadcast();
    }
}

