/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfd;

import io.vproxy.vfd.IP;
import io.vproxy.vfd.IPv4;
import io.vproxy.vfd.IPv6;

public class IPMask {
    private final IP ip;
    private final IP mask;
    private final int maskInt;

    public IPMask(IP ip, int mask) {
        this.mask = IP.fromMask(ip instanceof IPv6, mask);
        this.ip = ip;
        this.maskInt = mask;
    }

    public IPMask(IP ip, IP mask) {
        if (!mask.isMask()) {
            throw new IllegalArgumentException(mask + " is not a valid mask");
        }
        if (ip instanceof IPv4 && mask instanceof IPv6) {
            throw new IllegalArgumentException(ip + " and " + mask + " are not in the same address family");
        }
        if (ip instanceof IPv6 && mask instanceof IPv4) {
            throw new IllegalArgumentException(ip + " and " + mask + " are not in the same address family");
        }
        this.ip = ip;
        this.mask = mask;
        this.maskInt = mask.toPrefixLength();
    }

    public static IPMask from(String s) {
        int mask;
        if (!s.contains("/")) {
            throw new IllegalArgumentException("not ip/mask " + s);
        }
        String[] split = s.split("/");
        if (split.length != 2) {
            throw new IllegalArgumentException("not ip/mask " + s);
        }
        try {
            mask = Integer.parseInt(split[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
        return new IPMask(IP.from(split[0]), mask);
    }

    public IP ip() {
        return this.ip;
    }

    public IP mask() {
        return this.mask;
    }

    public int maskInt() {
        return this.maskInt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPMask ipMask = (IPMask)o;
        if (this.maskInt != ipMask.maskInt) {
            return false;
        }
        if (!this.ip.equals(ipMask.ip)) {
            return false;
        }
        return this.mask.equals(ipMask.mask);
    }

    public int hashCode() {
        int result = this.ip.hashCode();
        result = 31 * result + this.mask.hashCode();
        result = 31 * result + this.maskInt;
        return result;
    }

    public String toString() {
        return this.ip + "/" + this.maskInt;
    }

    public String formatToIPMaskString() {
        return this.ip.formatToIPString() + "/" + this.maskInt;
    }
}

