/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfd;

import io.vproxy.vfd.IP;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;

public class IPPort {
    private final IP ip;
    private final int port;
    private static final IPPort BIND_ANY_ADDRESS = new IPPort(IP.from("0.0.0.0"), 0);

    public IPPort(int port) {
        this(IP.from("0.0.0.0"), port);
    }

    public IPPort(String ip, int port) {
        this(IP.from(ip), port);
    }

    public IPPort(IP ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public IPPort(String ipport) {
        if (!IPPort.validL4AddrStr(ipport)) {
            throw new IllegalArgumentException("input is not a valid ipport string");
        }
        int port = Integer.parseInt(ipport.substring(ipport.lastIndexOf(58) + 1));
        String ip = ipport.substring(0, ipport.lastIndexOf(58));
        this.ip = IP.from(ip);
        this.port = port;
    }

    public static IPPort fromNullable(SocketAddress sockAddr) {
        if (sockAddr == null) {
            return null;
        }
        return IPPort.from(sockAddr);
    }

    public static IPPort from(SocketAddress sockAddr) {
        InetSocketAddress l4addr = (InetSocketAddress)sockAddr;
        return new IPPort(IP.from(l4addr.getAddress()), l4addr.getPort());
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.ip.toInetAddress(), this.port);
    }

    public IP getAddress() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String formatToIPPortString() {
        return this.ip.formatToIPString() + ":" + this.port;
    }

    public String toString() {
        return this.ip + ":" + this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPPort ipPort = (IPPort)o;
        return this.port == ipPort.port && Objects.equals(this.ip, ipPort.ip);
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.port);
    }

    public boolean ipportEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPPort ipPort = (IPPort)o;
        return this.port == ipPort.port && this.ip.ipEquals(ipPort.ip);
    }

    public static IPPort bindAnyAddress() {
        return BIND_ANY_ADDRESS;
    }

    public static boolean validL4AddrStr(String l4addr) {
        int port;
        if (!l4addr.contains(":")) {
            return false;
        }
        String portStr = l4addr.substring(l4addr.lastIndexOf(":") + 1);
        String l3addr = l4addr.substring(0, l4addr.lastIndexOf(":"));
        if (IP.parseIpString(l3addr) == null) {
            return false;
        }
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return port >= 0 && port <= 65535;
    }
}

