/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfd;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.Utils;
import io.vproxy.vfd.IP;
import io.vproxy.vfd.IPv6;
import java.net.Inet4Address;

public class IPv4
extends IP {
    private final int value;

    IPv4(String hostname, byte[] bytes) {
        super(hostname, ByteArray.from(bytes));
        this.value = this.bytes.int32(0);
    }

    @Override
    public Inet4Address toInetAddress() {
        return (Inet4Address)super.toInetAddress();
    }

    public int getIPv4Value() {
        return this.value;
    }

    public int maskValue(int maskNumber) {
        return this.value & Utils.maskNumberToInt(maskNumber);
    }

    @Override
    public IPv4 to4() {
        return this;
    }

    @Override
    public IPv6 to6() {
        return new IPv6(this.hostname, ByteArray.allocateInitZero(16).int16(10, 65535).int32(12, this.value).toJavaArray());
    }

    @Override
    public IPv4 stripHostname() {
        if (this.hostname == null) {
            return this;
        }
        return new IPv4(null, this.bytes.toJavaArray());
    }

    @Override
    public boolean ipEquals(Object that) {
        if (that == null) {
            return false;
        }
        if (!(that instanceof IPv4)) {
            return false;
        }
        IPv4 ipv4 = (IPv4)that;
        return this.value == ipv4.value;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public boolean isBroadcast() {
        return this.bytes.get(0) == -1 && this.bytes.get(1) == -1 && this.bytes.get(2) == -1 && this.bytes.get(3) == -1;
    }

    @Override
    public boolean isMulticast() {
        return (this.bytes.get(0) & 0xE0) == 224;
    }
}

