/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfd;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.Utils;
import io.vproxy.vfd.IP;
import io.vproxy.vfd.IPv4;
import java.net.Inet6Address;
import java.util.Objects;

public class IPv6
extends IP {
    private final int value0;
    private final int value1;
    private final int value2;
    private final int value3;

    IPv6(String hostname, byte[] bytes) {
        super(hostname, ByteArray.from(bytes));
        this.value0 = this.bytes.int32(0);
        this.value1 = this.bytes.int32(4);
        this.value2 = this.bytes.int32(8);
        this.value3 = this.bytes.int32(12);
    }

    @Override
    public Inet6Address toInetAddress() {
        return (Inet6Address)super.toInetAddress();
    }

    public int getIPv6Value0() {
        return this.value0;
    }

    public int getIPv6Value1() {
        return this.value1;
    }

    public int getIPv6Value2() {
        return this.value2;
    }

    public int getIPv6Value3() {
        return this.value3;
    }

    public Values getIPv6Values() {
        return new Values(this.value0, this.value1, this.value2, this.value3);
    }

    public Values maskValues(int maskNumber) {
        int mask = maskNumber;
        if (mask >= 128) {
            return new Values(this.value0, this.value1, this.value2, this.value3);
        }
        if (mask > 96) {
            return new Values(this.value0, this.value1, this.value2, this.value3 & Utils.maskNumberToInt(mask - 96));
        }
        if (mask > 64) {
            return new Values(this.value0, this.value1, this.value2 & Utils.maskNumberToInt(mask - 64), 0);
        }
        if (mask > 32) {
            return new Values(this.value0, this.value1 & Utils.maskNumberToInt(mask - 32), 0, 0);
        }
        return new Values(this.value0 & Utils.maskNumberToInt(mask), 0, 0, 0);
    }

    @Override
    public boolean ipEquals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof IPv6)) {
            return false;
        }
        IPv6 that = (IPv6)o;
        return this.value0 == that.value0 && this.value1 == that.value1 && this.value2 == that.value2 && this.value3 == that.value3;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value0, this.value1, this.value2, this.value3);
    }

    public String formatToIPStringWithoutBrackets() {
        String ipv6 = this.formatToIPString();
        if (ipv6.startsWith("[")) {
            ipv6 = ipv6.substring(1, ipv6.length() - 1);
        }
        return ipv6;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    @Override
    public boolean isMulticast() {
        return this.bytes.get(0) == -1;
    }

    public boolean isV4MappedV6Address() {
        return this.value0 == 0 && this.value1 == 0 && this.value2 == 65535;
    }

    public boolean isV4CompatibleV6Address() {
        return this.value0 == 0 && this.value1 == 0 && this.value2 == 0;
    }

    @Override
    public IPv4 to4() {
        if (this.isV4MappedV6Address() || this.isV4CompatibleV6Address()) {
            return new IPv4(this.hostname, ByteArray.allocate(4).int32(0, this.value3).toJavaArray());
        }
        return null;
    }

    @Override
    public IPv6 to6() {
        return this;
    }

    @Override
    public IPv6 stripHostname() {
        if (this.hostname == null) {
            return this;
        }
        return new IPv6(null, this.bytes.toJavaArray());
    }

    public static final class Values {
        public final int value0;
        public final int value1;
        public final int value2;
        public final int value3;

        public Values(int value0, int value1, int value2, int value3) {
            this.value0 = value0;
            this.value1 = value1;
            this.value2 = value2;
            this.value3 = value3;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Values values = (Values)o;
            return this.value0 == values.value0 && this.value1 == values.value1 && this.value2 == values.value2 && this.value3 == values.value3;
        }

        public int hashCode() {
            return Objects.hash(this.value0, this.value1, this.value2, this.value3);
        }
    }
}

